/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import jakarta.xml.bind.JAXBElement;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.generated.artdecor.ps.AllergienUnvertraeglichkeitenEntry;
import org.projecthusky.cda.elga.generated.artdecor.ps.AllergyProblemEntry;
import org.projecthusky.cda.elga.generated.artdecor.ps.AllergyStatusObservation;
import org.projecthusky.cda.elga.generated.artdecor.ps.CertaintyObservation;
import org.projecthusky.cda.elga.generated.artdecor.ps.CriticalityObservation;
import org.projecthusky.cda.elga.generated.artdecor.ps.ParticipantAllergy;
import org.projecthusky.cda.elga.models.AllergyReaction;
import org.projecthusky.cda.elga.models.Informant;
import org.projecthusky.cda.elga.models.PractitionerCdaAt;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.POCDMT000040Participant2;
import org.projecthusky.common.hl7cdar2.POCDMT000040ParticipantRole;
import org.projecthusky.common.hl7cdar2.POCDMT000040PlayingEntity;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.utils.time.DateTimes;

public class Allergy {
    private boolean active;
    private ZonedDateTime start;
    private ZonedDateTime stop;
    private PractitionerCdaAt author;
    private Informant informant;
    private Code kindOfAllergy;
    private Code absentAllergy;
    private List<AllergyReaction> reactions;
    private Code allergyAgent;
    private Code clinicalState;
    private Code verificationState;
    private Code criticality;
    private String text;

    public Allergy(String text) {
        this.text = text;
    }

    public Allergy(POCDMT000040Entry entry) {
    }

    public Code getAbsentAllergy() {
        return this.absentAllergy;
    }

    public Code getAllergyAgent() {
        return this.allergyAgent;
    }

    public PractitionerCdaAt getAuthor() {
        return this.author;
    }

    public Code getClinicalState() {
        return this.clinicalState;
    }

    public Code getCriticality() {
        return this.criticality;
    }

    public Informant getInformant() {
        return this.informant;
    }

    public Code getKindOfAllergy() {
        return this.kindOfAllergy;
    }

    public List<AllergyReaction> getReactions() {
        return this.reactions;
    }

    public ZonedDateTime getStart() {
        return this.start;
    }

    public ZonedDateTime getStop() {
        return this.stop;
    }

    public String getText() {
        return this.text;
    }

    public Code getVerificationState() {
        return this.verificationState;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setAbsentAllergy(Code absentAllergy) {
        this.absentAllergy = absentAllergy;
    }

    public void setActive(boolean state) {
        this.active = state;
    }

    public void setAllergyAgent(Code allergyAgent) {
        this.allergyAgent = allergyAgent;
    }

    public void setAuthor(PractitionerCdaAt author) {
        this.author = author;
    }

    public void setClinicalState(Code clinicalState) {
        this.clinicalState = clinicalState;
    }

    public void setCriticality(Code criticality) {
        this.criticality = criticality;
    }

    public void setInformant(Informant informant) {
        this.informant = informant;
    }

    public void setKindOfAllergy(Code kindOfAllergy) {
        this.kindOfAllergy = kindOfAllergy;
    }

    public void setReactions(List<AllergyReaction> reactions) {
        this.reactions = reactions;
    }

    public void setStart(ZonedDateTime start) {
        this.start = start;
    }

    public void setStop(ZonedDateTime stop) {
        this.stop = stop;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setVerificationState(Code verificationState) {
        this.verificationState = verificationState;
    }

    public POCDMT000040Entry getHl7CdaR2AllergyEntry(int index) {
        POCDMT000040Entry entry = new POCDMT000040Entry();
        entry.setAct((POCDMT000040Act)this.getAllergiesIntoleranceEntry(index));
        return entry;
    }

    protected AllergienUnvertraeglichkeitenEntry getAllergiesIntoleranceEntry(int index) {
        AllergienUnvertraeglichkeitenEntry allergyAct = new AllergienUnvertraeglichkeitenEntry();
        if (this.author != null) {
            allergyAct.addHl7Author(this.author.getAuthorBodyPs(this.start));
        }
        if (this.informant != null) {
            allergyAct.addHl7Informant(this.informant.getInformantBodyPs());
        }
        if (!this.active) {
            allergyAct.setStatusCode(new CS("completed"));
        }
        IVLTS time = new IVLTS();
        time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.start)));
        time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.stop)));
        allergyAct.setEffectiveTime(time);
        allergyAct.addHl7EntryRelationship(this.getAllergyProblemEntryObservation(index));
        return allergyAct;
    }

    protected POCDMT000040EntryRelationship getAllergyProblemEntryObservation(int index) {
        POCDMT000040EntryRelationship entry = new POCDMT000040EntryRelationship();
        AllergyProblemEntry allergyObservation = new AllergyProblemEntry();
        if (this.kindOfAllergy != null) {
            allergyObservation.setCode(this.kindOfAllergy.getHl7CdaR2Cd());
            allergyObservation.setText(new ED(null, new TEL("#typ" + index)));
        }
        allergyObservation.setStatusCode(new CS("completed"));
        allergyObservation.setEffectiveTime(this.getIVLTSTime());
        if (this.absentAllergy != null) {
            allergyObservation.setHl7Value((ANY)this.absentAllergy.getHl7CdaR2Cd());
        } else {
            if (this.reactions != null && !this.reactions.isEmpty()) {
                allergyObservation.getEntryRelationship().addAll(this.getAllergyReactions(this.reactions, index));
            }
            if (this.allergyAgent != null) {
                allergyObservation.getParticipant().add(this.getParticipantAllergy(index));
            }
            if (this.criticality != null) {
                allergyObservation.getEntryRelationship().add(this.getCriticalityObservationEntryRel(index));
            }
            if (this.verificationState != null) {
                allergyObservation.getEntryRelationship().add(this.getCertaintyObservationEntryRel(index));
            }
            if (this.clinicalState != null) {
                allergyObservation.getEntryRelationship().add(this.getAllergyStatusObservationEntryRel(index));
            }
        }
        entry.setObservation((POCDMT000040Observation)allergyObservation);
        return entry;
    }

    private List<POCDMT000040EntryRelationship> getAllergyReactions(List<AllergyReaction> reactions, int index) {
        LinkedList<POCDMT000040EntryRelationship> entryRels = new LinkedList<POCDMT000040EntryRelationship>();
        int indexReaction = 0;
        for (AllergyReaction reaction : reactions) {
            if (reaction == null) continue;
            entryRels.add(reaction.getAllergyReactionObservationEntryRel(indexReaction++, index));
        }
        return entryRels;
    }

    private IVLTS getIVLTSTime() {
        IVLTS time = new IVLTS();
        time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.start)));
        time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.stop)));
        return time;
    }

    protected POCDMT000040EntryRelationship getAllergyStatusObservationEntryRel(int index) {
        POCDMT000040EntryRelationship entryRel = null;
        if (this.clinicalState != null) {
            entryRel = new POCDMT000040EntryRelationship();
            entryRel.setTypeCode(XActRelationshipEntryRelationship.REFR);
            entryRel.setInversionInd(Boolean.valueOf(false));
            AllergyStatusObservation observation = new AllergyStatusObservation();
            observation.setText(new ED(null, new TEL("#status" + index)));
            CD code = this.clinicalState.getHl7CdaR2Cd();
            code.setOriginalText(new ED(null, new TEL("#state" + index)));
            observation.setHl7Value((ANY)code);
            entryRel.setObservation((POCDMT000040Observation)observation);
        }
        return entryRel;
    }

    protected POCDMT000040EntryRelationship getCertaintyObservationEntryRel(int index) {
        POCDMT000040EntryRelationship entryRel = null;
        if (this.verificationState != null) {
            entryRel = new POCDMT000040EntryRelationship();
            entryRel.setTypeCode(XActRelationshipEntryRelationship.SUBJ);
            entryRel.setInversionInd(Boolean.valueOf(true));
            CertaintyObservation observation = new CertaintyObservation();
            observation.setCode(new Code("NEW-LOINC-CERTAINTY", "2.16.840.1.113883.6.1", null, null).getHl7CdaR2Cd());
            CD code = this.verificationState.getHl7CdaR2Cd();
            code.setOriginalText(new ED(null, new TEL("#cert" + index)));
            observation.setHl7Value((ANY)code);
            entryRel.setObservation((POCDMT000040Observation)observation);
        }
        return entryRel;
    }

    protected POCDMT000040EntryRelationship getCriticalityObservationEntryRel(int index) {
        POCDMT000040EntryRelationship entryRel = null;
        if (this.criticality != null) {
            entryRel = new POCDMT000040EntryRelationship();
            entryRel.setTypeCode(XActRelationshipEntryRelationship.SUBJ);
            entryRel.setInversionInd(Boolean.valueOf(true));
            CriticalityObservation observation = new CriticalityObservation();
            CD code = this.criticality.getHl7CdaR2Cd();
            code.setOriginalText(new ED(null, new TEL("#crit" + index)));
            observation.setHl7Value((ANY)code);
            entryRel.setObservation((POCDMT000040Observation)observation);
        }
        return entryRel;
    }

    protected POCDMT000040Participant2 getParticipantAllergy(int index) {
        POCDMT000040Participant2 participant2 = null;
        if (this.allergyAgent != null) {
            participant2 = new POCDMT000040Participant2();
            participant2.getTypeCode().add("CSM");
            ParticipantAllergy participant = new ParticipantAllergy();
            participant.addHl7PlayingEntity(this.getHl7CdaR2Pocdmt000040PlayingEntity(participant.getPlayingEntity(), index));
            participant2.setParticipantRole((POCDMT000040ParticipantRole)participant);
        }
        return participant2;
    }

    protected POCDMT000040PlayingEntity getHl7CdaR2Pocdmt000040PlayingEntity(POCDMT000040PlayingEntity entity, int index) {
        if (this.allergyAgent != null && this.allergyAgent.getCode() != null) {
            CE retVal = this.allergyAgent.getHl7CdaR2Ce();
            retVal.setOriginalText(new ED(null, new TEL("#alg" + index)));
            entity.setCode(retVal);
        }
        return entity;
    }
}

