/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import jakarta.xml.bind.JAXBElement;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabrrEntryComment;
import org.projecthusky.cda.elga.generated.artdecor.EimpfEntryImpfrelevanteErkrankungProblemEntry;
import org.projecthusky.cda.elga.generated.artdecor.EimpfEntryImpfrelevanteErkrankungenProblemConcern;
import org.projecthusky.cda.elga.generated.artdecor.ps.GesundheitsproblemBedenkenEntry;
import org.projecthusky.cda.elga.generated.artdecor.ps.ProblemEntryGesundheitsproblem;
import org.projecthusky.cda.elga.models.Appendix;
import org.projecthusky.cda.elga.models.Comment;
import org.projecthusky.cda.elga.models.PractitionerCdaAt;
import org.projecthusky.cda.elga.models.Translation;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.IVXBTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040ExternalDocument;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.POCDMT000040Reference;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntry;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.hl7cdar2.XActRelationshipExternalReference;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.utils.time.DateTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Disease {
    private static final Logger LOGGER = LoggerFactory.getLogger(Disease.class);
    private Identificator id;
    private boolean active;
    private Code problem;
    private ZonedDateTime start;
    private ZonedDateTime stop;
    private List<Comment> comments;
    private PractitionerCdaAt author;
    private ZonedDateTime authorTime;
    private Appendix originalDoc;
    private List<Translation> translations;

    public Disease() {
    }

    public Disease(POCDMT000040Entry entry) {
        if (entry != null && entry.getAct() != null) {
            if (entry.getAct().getStatusCode() != null) {
                this.active = "active".equalsIgnoreCase(entry.getAct().getStatusCode().getCode());
            }
            if (entry.getAct().getEffectiveTime() != null) {
                Map<String, TS> timeMap = this.getTsElement(entry.getAct().getEffectiveTime());
                try {
                    this.start = DateTimes.toLocalDate((TS)timeMap.get("low")).atStartOfDay(ZoneId.systemDefault());
                }
                catch (Exception e) {
                    LOGGER.error("{}: {}", (Object)e.getMessage(), (Object)timeMap.get("low").getValue());
                }
                try {
                    this.stop = DateTimes.toLocalDate((TS)timeMap.get("high")).atStartOfDay(ZoneId.systemDefault());
                }
                catch (Exception e) {
                    LOGGER.error("{}: {}", (Object)e.getMessage(), (Object)timeMap.get("high"));
                }
            }
            this.extractDiseaseCode(entry);
        }
    }

    public Code getProblem() {
        return this.problem;
    }

    public ZonedDateTime getStart() {
        return this.start;
    }

    public ZonedDateTime getStop() {
        return this.stop;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setProblem(Code problem) {
        this.problem = problem;
    }

    public void setStart(ZonedDateTime start) {
        this.start = start;
    }

    public void setStop(ZonedDateTime stop) {
        this.stop = stop;
    }

    public List<Comment> getComment() {
        return this.comments;
    }

    public void setComment(List<Comment> comment) {
        this.comments = comment;
    }

    public List<Translation> getTranslations() {
        return this.translations;
    }

    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public Identificator getId() {
        return this.id;
    }

    public void setId(Identificator id) {
        this.id = id;
    }

    public PractitionerCdaAt getAuthor() {
        return this.author;
    }

    public void setAuthor(PractitionerCdaAt author) {
        this.author = author;
    }

    public ZonedDateTime getAuthorTime() {
        return this.authorTime;
    }

    public void setAuthorTime(ZonedDateTime authorTime) {
        this.authorTime = authorTime;
    }

    public Appendix getOriginalDoc() {
        return this.originalDoc;
    }

    public void setOriginalDoc(Appendix originalDoc) {
        this.originalDoc = originalDoc;
    }

    private void extractDiseaseCode(POCDMT000040Entry entry) {
        for (POCDMT000040EntryRelationship entryRel : entry.getAct().getEntryRelationship()) {
            if (entryRel == null || entryRel.getObservation() == null) continue;
            for (ANY any : entryRel.getObservation().getValue()) {
                if (!(any instanceof CD)) continue;
                CD cd = (CD)any;
                this.problem = new Code(cd);
            }
        }
    }

    public POCDMT000040Entry getGesundheitsProblemEntry(int referenceIndex) {
        POCDMT000040Entry entry = new POCDMT000040Entry();
        entry.setTypeCode(XActRelationshipEntry.DRIV);
        GesundheitsproblemBedenkenEntry act = new GesundheitsproblemBedenkenEntry();
        II problemId = new II();
        problemId.getNullFlavor().add("UNK");
        act.getId().add(problemId);
        if (!this.active) {
            act.setStatusCode(new CS("completed"));
        }
        IVLTS time = new IVLTS();
        time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.start)));
        time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.stop)));
        act.setHl7EffectiveTime(time);
        POCDMT000040EntryRelationship entryRel = (POCDMT000040EntryRelationship)act.getEntryRelationship().get(0);
        entryRel.setObservation((POCDMT000040Observation)this.getProblemEntryGesundheitsproblem(referenceIndex, problemId));
        entry.setAct((POCDMT000040Act)act);
        return entry;
    }

    protected ProblemEntryGesundheitsproblem getProblemEntryGesundheitsproblem(int referenceIndex, II problemId) {
        ProblemEntryGesundheitsproblem observation = new ProblemEntryGesundheitsproblem();
        observation.getId().add(problemId);
        CD cd = new CD();
        cd.getNullFlavor().add("UNK");
        observation.setCode(cd);
        if (this.problem != null) {
            CD problemCD = this.problem.getHl7CdaR2Cd();
            problemCD.setOriginalText(new ED(null, new TEL("#classification-" + referenceIndex)));
            observation.setHl7Value((ANY)problemCD);
        }
        return observation;
    }

    protected EimpfEntryImpfrelevanteErkrankungProblemEntry getEimpfEntryImpfrelevanteErkrankungProblemEntry(int referenceIndex) {
        EimpfEntryImpfrelevanteErkrankungProblemEntry observation = new EimpfEntryImpfrelevanteErkrankungProblemEntry();
        IVLTS time = new IVLTS();
        time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.start)));
        time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.stop)));
        observation.setHl7EffectiveTime(time);
        if (this.id != null) {
            observation.getId().clear();
            II problemId = this.id.getHl7CdaR2Ii();
            problemId.setExtension(problemId.getExtension() + "_" + referenceIndex);
            observation.getId().add(this.id.getHl7CdaR2Ii());
        }
        if (this.problem != null) {
            CD problemCD = this.problem.getHl7CdaR2Cd();
            problemCD.setOriginalText(new ED(null, new TEL("#relevanteDisease-" + referenceIndex)));
            observation.setHl7Value(problemCD);
        }
        observation.setHl7Text(new ED(null, new TEL("#relevanteDisease-" + referenceIndex)));
        observation.getEntryRelationship().clear();
        if (this.comments != null && !this.comments.isEmpty()) {
            this.setComments(observation, referenceIndex);
        }
        return observation;
    }

    private void setComments(EimpfEntryImpfrelevanteErkrankungProblemEntry observation, int referenceIndex) {
        for (Comment comment : this.comments) {
            if (comment == null) continue;
            POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
            entryRel.setTypeCode(XActRelationshipEntryRelationship.COMP);
            entryRel.setContextConductionInd(Boolean.valueOf(true));
            AtcdabrrEntryComment entryComment = comment.getAtcdabbrEntryComment(referenceIndex);
            entryComment.setText(new ED(null, new TEL("#relevantDiseases-comment-" + referenceIndex)));
            entryRel.setAct((POCDMT000040Act)entryComment);
            observation.getEntryRelationship().add(entryRel);
        }
    }

    public EimpfEntryImpfrelevanteErkrankungenProblemConcern getEimpfEntryImpfrelevanteErkrankungenProblemConcern(int referenceIndex) {
        EimpfEntryImpfrelevanteErkrankungenProblemConcern problemConcernAct = new EimpfEntryImpfrelevanteErkrankungenProblemConcern();
        if (this.active) {
            problemConcernAct.setHl7StatusCode(new CS("active"));
            if (this.start != null) {
                time = new IVLTS();
                time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.start)));
                problemConcernAct.setEffectiveTime(time);
            }
        } else {
            problemConcernAct.setHl7StatusCode(new CS("completed"));
            if (this.start != null && this.stop != null) {
                time = new IVLTS();
                time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.start)));
                time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.stop)));
                problemConcernAct.setEffectiveTime(time);
            }
        }
        if (this.author != null) {
            problemConcernAct.getHl7Author().add(this.author.getAuthorBodyPs(this.authorTime));
        }
        if (this.id != null) {
            problemConcernAct.getId().clear();
            problemConcernAct.getId().add(this.id.getHl7CdaR2Ii());
        }
        problemConcernAct.getEntryRelationship().clear();
        if (this.problem != null) {
            POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
            entryRel.setTypeCode(XActRelationshipEntryRelationship.SUBJ);
            entryRel.setInversionInd(Boolean.valueOf(false));
            entryRel.setContextConductionInd(Boolean.valueOf(true));
            entryRel.setObservation((POCDMT000040Observation)this.getEimpfEntryImpfrelevanteErkrankungProblemEntry(referenceIndex));
            problemConcernAct.getEntryRelationship().add(entryRel);
        }
        if (this.originalDoc != null) {
            POCDMT000040Reference reference = new POCDMT000040Reference();
            reference.setTypeCode(XActRelationshipExternalReference.REFR);
            reference.setExternalDocument((POCDMT000040ExternalDocument)this.originalDoc.getAtcdabbrEntryExternalDocument(referenceIndex));
            problemConcernAct.setHl7Reference(reference);
        }
        return problemConcernAct;
    }

    protected Map<String, TS> getTsElement(IVLTS time) {
        HashMap<String, TS> tsElements = new HashMap<String, TS>();
        if (time != null) {
            for (JAXBElement ts : time.getRest()) {
                IVXBTS value = null;
                String elementName = "";
                if (ts != null && IVXBTS.class.equals((Object)ts.getDeclaredType()) && ts.getValue() != null) {
                    value = (IVXBTS)ts.getValue();
                }
                if (ts != null && ts.getName() != null) {
                    elementName = ts.getName().getLocalPart();
                }
                if (value == null || elementName == null) continue;
                tsElements.put(elementName, (TS)value);
            }
        }
        return tsElements;
    }
}

