/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import java.util.LinkedList;
import java.util.List;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrOtherInformantBody;
import org.projecthusky.cda.elga.generated.artdecor.enums.ElgaAuthorSpeciality;
import org.projecthusky.cda.elga.generated.artdecor.enums.ElgaPersonalRelationship;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.POCDMT000040AssignedEntity;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organization;
import org.projecthusky.common.hl7cdar2.POCDMT000040Person;
import org.projecthusky.common.hl7cdar2.POCDMT000040RelatedEntity;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.model.Address;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Name;
import org.projecthusky.common.model.Organization;
import org.projecthusky.common.model.Telecom;

public class Informant {
    private ElgaPersonalRelationship persRel;
    private ElgaAuthorSpeciality authorSpeciality;
    private Name name;
    private List<Identificator> ids;
    private Organization organization;
    private List<Address> addresses;
    private List<Telecom> telecoms;

    public Name getName() {
        return this.name;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public ElgaPersonalRelationship getPersRel() {
        return this.persRel;
    }

    public void setIds(List<Identificator> ids) {
        this.ids = ids;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public void setPersRel(ElgaPersonalRelationship persRel) {
        this.persRel = persRel;
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public List<Telecom> getTelecoms() {
        return this.telecoms;
    }

    public void setTelecoms(List<Telecom> telecoms) {
        this.telecoms = telecoms;
    }

    public List<Identificator> getIds() {
        return this.ids;
    }

    public ElgaAuthorSpeciality getAuthorSpeciality() {
        return this.authorSpeciality;
    }

    public void setAuthorSpeciality(ElgaAuthorSpeciality authorSpeciality) {
        this.authorSpeciality = authorSpeciality;
    }

    protected AtcdabbrOtherInformantBody getInformantBodyPs() {
        AtcdabbrOtherInformantBody informantBody = new AtcdabbrOtherInformantBody();
        if (this.persRel != null) {
            informantBody.setHl7RelatedEntity(this.getHl7CdaR2Pocdmt000040RelatedEntity(AtcdabbrOtherInformantBody.getPredefinedRelatedEntityPrs()));
        } else {
            informantBody.setHl7AssignedEntity(this.getHl7CdaR2Pocdmt000040AssignedEntity(AtcdabbrOtherInformantBody.getPredefinedAssignedEntityAssigned()));
        }
        return informantBody;
    }

    protected POCDMT000040RelatedEntity getHl7CdaR2Pocdmt000040RelatedEntity(POCDMT000040RelatedEntity entity) {
        if (this.persRel != null) {
            entity.setCode(new CE(this.persRel.getCode().getCode(), this.persRel.getCode().getCodeSystem(), this.persRel.getCode().getCodeSystemName(), this.persRel.getCode().getDisplayName()));
        }
        if (this.addresses != null && !this.addresses.isEmpty()) {
            for (Address address : this.addresses) {
                if (address == null) continue;
                entity.getAddr().add(address.getHl7CdaR2Ad());
            }
        }
        if (this.telecoms != null && !this.telecoms.isEmpty()) {
            entity.getTelecom().addAll(this.getTel());
        }
        if (this.name != null) {
            entity.setRelatedPerson(this.getHl7CdaR2Pocdmt000040Person(new POCDMT000040Person()));
        }
        return entity;
    }

    private List<TEL> getTel() {
        LinkedList<TEL> tel = new LinkedList<TEL>();
        for (Telecom telecom : this.telecoms) {
            if (telecom == null) continue;
            tel.add(telecom.getHl7CdaR2Tel());
        }
        return tel;
    }

    private List<II> getIi() {
        LinkedList<II> iis = new LinkedList<II>();
        for (Identificator id : this.ids) {
            if (id != null) {
                iis.add(id.getHl7CdaR2Ii());
                continue;
            }
            Identificator niId = new Identificator();
            niId.setNullFlavor(NullFlavor.NOINFORMATION);
            iis.add(niId.getHl7CdaR2Ii());
        }
        return iis;
    }

    protected POCDMT000040AssignedEntity getHl7CdaR2Pocdmt000040AssignedEntity(POCDMT000040AssignedEntity assignedEntity) {
        assignedEntity.setClassCode("ASSIGNED");
        if (this.ids != null && !this.ids.isEmpty()) {
            assignedEntity.getId().addAll(this.getIi());
        } else {
            Identificator unknownId = new Identificator();
            unknownId.setNullFlavor(NullFlavor.UNKNOWN_L1);
            assignedEntity.getId().add(unknownId.getHl7CdaR2Ii());
        }
        if (this.name != null) {
            assignedEntity.setAssignedPerson(this.getHl7CdaR2Pocdmt000040Person(new POCDMT000040Person()));
        }
        if (this.organization != null) {
            POCDMT000040Organization legalAuthenOrg = new POCDMT000040Organization();
            legalAuthenOrg.setClassCode("ORG");
            legalAuthenOrg.setDeterminerCode("INSTANCE");
            assignedEntity.setRepresentedOrganization(this.organization.getHl7CdaR2Pocdmt000040Organization(legalAuthenOrg));
        }
        if (this.authorSpeciality != null) {
            assignedEntity.setCode(new CE(this.authorSpeciality.getCode().getCode(), this.authorSpeciality.getCode().getCodeSystem(), this.authorSpeciality.getCode().getCodeSystemName(), this.authorSpeciality.getCode().getDisplayName()));
        }
        if (this.addresses != null && !this.addresses.isEmpty() && this.addresses.get(0) != null) {
            assignedEntity.getAddr().add(this.addresses.get(0).getHl7CdaR2Ad());
        }
        if (this.telecoms != null && !this.telecoms.isEmpty()) {
            assignedEntity.getTelecom().addAll(this.getTel());
        }
        return assignedEntity;
    }

    protected POCDMT000040Person getHl7CdaR2Pocdmt000040Person(POCDMT000040Person person) {
        if (this.name != null) {
            person.getName().add(this.name.getHl7CdaR2Pn());
            if (person.getClassCode().isEmpty()) {
                person.getClassCode().add("PSN");
            }
            person.setDeterminerCode("INSTANCE");
        }
        return person;
    }
}

