/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.COCTMT230100UVIngredient;
import org.projecthusky.common.hl7cdar2.COCTMT230100UVSubstance;
import org.projecthusky.common.hl7cdar2.TN;
import org.projecthusky.common.model.Code;

public class Ingredient {
    private Code code;
    private String name;

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public COCTMT230100UVIngredient getCOCTMT230100UVIngredient() {
        COCTMT230100UVIngredient ingredientField = new COCTMT230100UVIngredient();
        ingredientField.setClassCode("ACTI");
        COCTMT230100UVSubstance substance = new COCTMT230100UVSubstance();
        substance.setClassCode("MMAT");
        substance.setDeterminerCode("KIND");
        if (this.code != null) {
            substance.setCode(this.code.getHl7CdaR2Ce());
        } else {
            CE substanceCode = new CE();
            substanceCode.nullFlavor = new ArrayList();
            substanceCode.nullFlavor.add("UNK");
            substance.setCode(substanceCode);
        }
        if (this.name != null) {
            TN pharmName = new TN();
            pharmName.setXmlMixed(this.name);
            substance.getName().add(pharmName);
        }
        ingredientField.setIngredient(new JAXBElement(new QName("urn:ihe:pharm", "ingredient", "pharm"), COCTMT230100UVSubstance.class, (Object)substance));
        return ingredientField;
    }
}

