/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import jakarta.xml.bind.JAXBElement;
import java.math.BigInteger;
import java.util.Date;
import javax.xml.namespace.QName;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.BL;
import org.projecthusky.common.hl7cdar2.CV;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.INT;
import org.projecthusky.common.hl7cdar2.IVLINT;
import org.projecthusky.common.hl7cdar2.IVLPQ;
import org.projecthusky.common.hl7cdar2.PQ;
import org.projecthusky.common.hl7cdar2.QTY;
import org.projecthusky.common.hl7cdar2.RTO;
import org.projecthusky.common.hl7cdar2.RTOPQPQ;
import org.projecthusky.common.hl7cdar2.ST;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.utils.DateUtil;

public class LaboratoryValue {
    private Double lowValue;
    private Double highValue;
    private Double doubleValue;
    private BigInteger intValue;
    private Boolean boolValue;
    private String stringValue;
    private Date dateValue;
    private Code codeValue;
    private String unit;
    private boolean inclusive;
    private Integer numerator;
    private Integer denominator;

    public Double getLowValue() {
        return this.lowValue;
    }

    public void setLowValue(Double lowValue) {
        this.lowValue = lowValue;
    }

    public Double getHighValue() {
        return this.highValue;
    }

    public void setHighValue(Double highValue) {
        this.highValue = highValue;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public BigInteger getIntValue() {
        return this.intValue;
    }

    public void setIntValue(BigInteger intValue) {
        this.intValue = intValue;
    }

    public Boolean getBoolValue() {
        return this.boolValue;
    }

    public void setBoolValue(Boolean boolValue) {
        this.boolValue = boolValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(Date dateValue) {
        this.dateValue = dateValue;
    }

    public Code getCodeValue() {
        return this.codeValue;
    }

    public void setCodeValue(Code codeValue) {
        this.codeValue = codeValue;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public void setInclusive(boolean inclusive) {
        this.inclusive = inclusive;
    }

    public Integer getNumerator() {
        return this.numerator;
    }

    public void setNumerator(Integer numerator) {
        this.numerator = numerator;
    }

    public Integer getDenominator() {
        return this.denominator;
    }

    public void setDenominator(Integer denominator) {
        this.denominator = denominator;
    }

    public PQ getPQ() {
        PQ pq = new PQ();
        pq.setUnit(this.unit);
        pq.setValue(String.valueOf(this.doubleValue));
        return pq;
    }

    public IVLPQ getIVLPQ() {
        IVLPQ ivlpq = new IVLPQ();
        if (this.lowValue != null) {
            ivlpq.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), IVLPQ.class, (Object)new IVLPQ(String.valueOf(this.lowValue), this.unit)));
        }
        ivlpq.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), IVLPQ.class, (Object)new IVLPQ(String.valueOf(this.highValue), this.unit)));
        return ivlpq;
    }

    public INT getINT() {
        INT intVal = new INT();
        if (this.intValue != null) {
            intVal.setValue(this.intValue);
        }
        return intVal;
    }

    public IVLINT getIVLINT() {
        IVLINT intVal = new IVLINT();
        if (this.lowValue != null) {
            intVal.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), INT.class, (Object)new INT(this.lowValue.intValue())));
        }
        if (this.highValue != null) {
            intVal.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), INT.class, (Object)new INT(this.highValue.intValue())));
        }
        return intVal;
    }

    public BL getBL() {
        BL blValue = new BL();
        blValue.setValue(this.boolValue);
        return blValue;
    }

    public CV getCV() {
        CV cvValue = new CV();
        if (this.codeValue != null) {
            cvValue.setCode(this.codeValue.getCode());
            cvValue.setCodeSystem(this.codeValue.getCodeSystem());
            cvValue.setCodeSystemName(this.codeValue.getCodeSystemName());
            cvValue.setCodeSystemVersion(this.codeValue.getCodeSystemVersion());
            cvValue.setDisplayName(this.codeValue.getDisplayName());
            cvValue.setOriginalText(new ED(null, new TEL(this.codeValue.getOriginalText())));
        }
        return cvValue;
    }

    public TS getTS() {
        if (this.dateValue == null) {
            return new TS("UNK");
        }
        return new TS(DateUtil.formatDateTimeTzon((Date)this.dateValue));
    }

    public RTO getRTO() {
        INT intVal;
        RTO rto = new RTO();
        if (this.numerator != null) {
            intVal = new INT();
            intVal.setValue(BigInteger.valueOf(this.numerator.intValue()));
            rto.setNumerator((QTY)intVal);
        }
        if (this.denominator != null) {
            intVal = new INT();
            intVal.setValue(BigInteger.valueOf(this.denominator.intValue()));
            rto.setDenominator((QTY)intVal);
        }
        return rto;
    }

    public RTOPQPQ getRTOPQPQ() {
        RTOPQPQ rtopqpq = new RTOPQPQ();
        PQ pqVal = new PQ();
        pqVal.setValue(String.valueOf(this.numerator));
        pqVal.setUnit(this.unit);
        rtopqpq.setNumerator(pqVal);
        PQ pqValDen = new PQ();
        pqValDen.setValue(String.valueOf(this.denominator));
        pqValDen.setUnit(this.unit);
        rtopqpq.setDenominator(pqValDen);
        return rtopqpq;
    }

    public ST getST() {
        ST st = new ST();
        st.setXmlMixed(this.stringValue);
        return st;
    }

    public ANY getValue() {
        if (this.numerator != null && this.denominator != null && this.unit != null) {
            return this.getRTOPQPQ();
        }
        if (this.numerator != null && this.denominator != null) {
            return this.getRTO();
        }
        if (this.intValue != null) {
            return this.getINT();
        }
        if (this.codeValue != null) {
            return this.getCV();
        }
        if (this.dateValue != null) {
            return this.getTS();
        }
        if (this.doubleValue != null && this.unit != null) {
            return this.getPQ();
        }
        if (this.lowValue != null && this.unit != null && !this.unit.isEmpty()) {
            return this.getIVLPQ();
        }
        if (this.lowValue != null && this.highValue != null) {
            return this.getIVLINT();
        }
        if (this.boolValue != null) {
            return this.getBL();
        }
        if (this.stringValue != null) {
            return this.getST();
        }
        return null;
    }

    public String getValueAsString() {
        if (this.stringValue != null && !this.stringValue.isEmpty()) {
            return this.stringValue;
        }
        if (this.intValue != null) {
            return this.intValue.toString();
        }
        if (this.highValue != null && this.lowValue != null) {
            return String.format("%s - %s", this.lowValue.toString(), this.highValue.toString());
        }
        if (this.doubleValue != null) {
            return this.doubleValue.toString();
        }
        if (this.denominator != null && this.numerator != null) {
            return String.format("%s:%s", this.numerator.toString(), this.denominator.toString());
        }
        if (this.dateValue != null) {
            return DateUtil.formatDateTimeTzon((Date)this.dateValue);
        }
        if (this.codeValue != null && this.codeValue.getDisplayName() != null) {
            return this.codeValue.getDisplayName();
        }
        if (this.boolValue != null) {
            return this.boolValue.toString();
        }
        return "";
    }
}

