/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.eimpf;

import jakarta.xml.bind.JAXBElement;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.generated.artdecor.EimpfEntryAntikoerperBestimmungBatteryOrganizer;
import org.projecthusky.cda.elga.generated.artdecor.EimpfEntryAntikoerperBestimmungDataProcessing;
import org.projecthusky.cda.elga.generated.artdecor.enums.EImpfAntikoerperbestimmungVs;
import org.projecthusky.cda.elga.models.Appendix;
import org.projecthusky.cda.elga.models.PractitionerCdaAt;
import org.projecthusky.cda.elga.models.Translation;
import org.projecthusky.cda.elga.models.eimpf.AntibodyLaboratory;
import org.projecthusky.common.hl7cdar2.ActRelationshipHasComponent;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component4;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040ExternalDocument;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organizer;
import org.projecthusky.common.hl7cdar2.POCDMT000040Reference;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntry;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.utils.time.DateTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntibodyDetermination {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AntibodyDetermination.class.getName());
    private PractitionerCdaAt author;
    private ZonedDateTime timeAuthor;
    private ZonedDateTime startDate;
    private ZonedDateTime stopDate;
    private EImpfAntikoerperbestimmungVs antibodyDeterminationCode;
    private List<AntibodyLaboratory> antibodyLaboratory;
    private Appendix externalDocument;
    private List<Translation> translations;

    public PractitionerCdaAt getAuthor() {
        return this.author;
    }

    public void setAuthor(PractitionerCdaAt author) {
        this.author = author;
    }

    public ZonedDateTime getTimeAuthor() {
        return this.timeAuthor;
    }

    public void setTimeAuthor(ZonedDateTime timeAuthor) {
        this.timeAuthor = timeAuthor;
    }

    public ZonedDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(ZonedDateTime startDate) {
        this.startDate = startDate;
    }

    public ZonedDateTime getStopDate() {
        return this.stopDate;
    }

    public void setStopDate(ZonedDateTime stopDate) {
        this.stopDate = stopDate;
    }

    public EImpfAntikoerperbestimmungVs getAntibodyDetermination() {
        return this.antibodyDeterminationCode;
    }

    public void setAntibodyDetermination(EImpfAntikoerperbestimmungVs antibodyDetermination) {
        this.antibodyDeterminationCode = antibodyDetermination;
    }

    public List<AntibodyLaboratory> getAntibodyLaboratory() {
        return this.antibodyLaboratory;
    }

    public void setAntibodyLaboratory(List<AntibodyLaboratory> antibodyLaboratory) {
        this.antibodyLaboratory = antibodyLaboratory;
    }

    public Appendix getExternalDocument() {
        return this.externalDocument;
    }

    public void setExternalDocument(Appendix externalDocument) {
        this.externalDocument = externalDocument;
    }

    public List<Translation> getTranslations() {
        return this.translations;
    }

    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public EimpfEntryAntikoerperBestimmungDataProcessing getEimpfEntryAntikoerperBestimmungDataProcessing(int index) {
        EimpfEntryAntikoerperBestimmungDataProcessing processing = new EimpfEntryAntikoerperBestimmungDataProcessing();
        processing.setTypeCode(XActRelationshipEntry.DRIV);
        processing.setContextConductionInd(true);
        POCDMT000040Act act = processing.getAct();
        if (this.author != null) {
            act.getAuthor().add(this.author.getAtcdabbrOtherAuthorBodyEImpfpass(this.timeAuthor));
        }
        POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
        entryRel.setTypeCode(XActRelationshipEntryRelationship.COMP);
        entryRel.setContextConductionInd(Boolean.valueOf(true));
        entryRel.setOrganizer((POCDMT000040Organizer)this.getEimpfEntryAntikoerperBestimmungBatteryOrganizer());
        act.getEntryRelationship().add(entryRel);
        if (this.externalDocument != null) {
            POCDMT000040Reference reference = new POCDMT000040Reference();
            reference.setExternalDocument((POCDMT000040ExternalDocument)this.externalDocument.getAtcdabbrEntryExternalDocument(index));
            act.getReference().add(reference);
        }
        processing.setAct(act);
        return processing;
    }

    protected EimpfEntryAntikoerperBestimmungBatteryOrganizer getEimpfEntryAntikoerperBestimmungBatteryOrganizer() {
        EimpfEntryAntikoerperBestimmungBatteryOrganizer organizer = new EimpfEntryAntikoerperBestimmungBatteryOrganizer();
        if (this.antibodyDeterminationCode != null) {
            organizer.setCode((CD)new CE(this.antibodyDeterminationCode.getCode().getCode(), this.antibodyDeterminationCode.getCode().getCodeSystem(), this.antibodyDeterminationCode.getCode().getCodeSystemName(), this.antibodyDeterminationCode.getCode().getDisplayName()));
        }
        TS start = null;
        TS stop = null;
        try {
            start = DateTimes.toDatetimeTs((TemporalAccessor)this.startDate);
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        try {
            stop = DateTimes.toDatetimeTs((TemporalAccessor)this.stopDate);
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        organizer.setEffectiveTime(this.createIntervalEffectiveTime(start, stop));
        if (this.antibodyLaboratory != null) {
            int laboratoryIndex = 0;
            for (AntibodyLaboratory laboratory : this.antibodyLaboratory) {
                if (laboratory == null) continue;
                POCDMT000040Component4 comp = new POCDMT000040Component4();
                comp.setTypeCode(ActRelationshipHasComponent.COMP);
                comp.setContextConductionInd(Boolean.valueOf(true));
                comp.setObservation((POCDMT000040Observation)laboratory.getEimpfEntryAntikoerperBestimmungLaboratoryObservation(laboratoryIndex++));
                organizer.getComponent().add(comp);
            }
        }
        return organizer;
    }

    protected IVLTS createIntervalEffectiveTime(TS low, TS high) {
        IVLTS ivlts = new IVLTS();
        ivlts.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)low));
        ivlts.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)high));
        return ivlts;
    }
}

