/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.ems;

import java.time.ZonedDateTime;
import org.projecthusky.cda.elga.generated.artdecor.ems.EpimsEntryActTaetigkeitsbereich;
import org.projecthusky.cda.elga.generated.artdecor.ems.EpimsEntryOrganizerTaetigkeitsbereich;
import org.projecthusky.cda.elga.utils.DateTimeUtils;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component4;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organizer;
import org.projecthusky.common.model.Code;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityArea {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityArea.class);
    private Code area;
    private ZonedDateTime startDate;
    private ZonedDateTime stopDate;

    public Code getArea() {
        return this.area;
    }

    public void setArea(Code area) {
        this.area = area;
    }

    public ZonedDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(ZonedDateTime startDate) {
        this.startDate = startDate;
    }

    public ZonedDateTime getStopDate() {
        return this.stopDate;
    }

    public void setStopDate(ZonedDateTime stopDate) {
        this.stopDate = stopDate;
    }

    public POCDMT000040Entry getEpimsEntryOrganizerBetreuungEntry() {
        POCDMT000040Entry entry = new POCDMT000040Entry();
        entry.setOrganizer(this.getEpimsEntryOrganizerTaetigkeitsbereich());
        return entry;
    }

    public POCDMT000040Organizer getEpimsEntryOrganizerTaetigkeitsbereich() {
        EpimsEntryOrganizerTaetigkeitsbereich organizerCare = new EpimsEntryOrganizerTaetigkeitsbereich();
        ((POCDMT000040Component4)organizerCare.getComponent().get(0)).setAct((POCDMT000040Act)this.getEpimsEntryActTaetigkeitsbereich());
        return organizerCare;
    }

    public EpimsEntryActTaetigkeitsbereich getEpimsEntryActTaetigkeitsbereich() {
        EpimsEntryActTaetigkeitsbereich activityArea = new EpimsEntryActTaetigkeitsbereich();
        if (this.area != null) {
            activityArea.setCode(this.area.getHl7CdaR2Cd());
        } else {
            LOGGER.error("facility of care is null");
        }
        if (this.stopDate == null && this.startDate == null) {
            return activityArea;
        }
        activityArea.setEffectiveTime(DateTimeUtils.createIvlts(this.startDate, this.stopDate));
        return activityArea;
    }
}

