/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.ems;

import java.time.ZonedDateTime;
import java.util.List;
import org.projecthusky.cda.elga.generated.artdecor.ems.EpimsEntryProblemConcern;
import org.projecthusky.cda.elga.models.ems.ClinicalManifestationItem;
import org.projecthusky.cda.elga.utils.DateTimeUtils;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.model.Identificator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClinicalManifestation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClinicalManifestation.class);
    private String rootId;
    private ZonedDateTime startDate;
    private ZonedDateTime stopDate;
    private List<ClinicalManifestationItem> clinicalManifestationItems;

    public String getRootId() {
        return this.rootId;
    }

    public void setRootId(String rootId) {
        this.rootId = rootId;
    }

    public ZonedDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(ZonedDateTime startDate) {
        this.startDate = startDate;
    }

    public ZonedDateTime getStopDate() {
        return this.stopDate;
    }

    public void setStopDate(ZonedDateTime stopDate) {
        this.stopDate = stopDate;
    }

    public List<ClinicalManifestationItem> getClinicalManifestationItems() {
        return this.clinicalManifestationItems;
    }

    public void setClinicalManifestationItems(List<ClinicalManifestationItem> clinicalManifestationItems) {
        this.clinicalManifestationItems = clinicalManifestationItems;
    }

    public POCDMT000040Entry getEpimsEntryProblemConcernEntry() {
        POCDMT000040Entry entry = new POCDMT000040Entry();
        entry.setAct((POCDMT000040Act)this.getEpimsEntryProblemConcern());
        return entry;
    }

    public EpimsEntryProblemConcern getEpimsEntryProblemConcern() {
        EpimsEntryProblemConcern problemConcern = new EpimsEntryProblemConcern();
        Identificator idProblemConcern = new Identificator();
        idProblemConcern.setRoot(this.rootId);
        idProblemConcern.setExtension("EMS-problem-concern");
        problemConcern.setHl7Id(idProblemConcern.getHl7CdaR2Ii());
        problemConcern.setEffectiveTime(DateTimeUtils.createIvlts(this.startDate, this.stopDate));
        if (this.clinicalManifestationItems != null && !this.clinicalManifestationItems.isEmpty()) {
            problemConcern.getEntryRelationship().clear();
            int index = 1;
            for (ClinicalManifestationItem item : this.clinicalManifestationItems) {
                if (item == null) continue;
                POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
                entryRel.setTypeCode(XActRelationshipEntryRelationship.SUBJ);
                entryRel.setContextConductionInd(Boolean.valueOf(true));
                entryRel.setInversionInd(Boolean.valueOf(false));
                entryRel.setObservation((POCDMT000040Observation)item.getEpimsEntryProblem(new Identificator(this.rootId, String.format("EMS-problem-%d", index)), index++));
                problemConcern.addHl7EntryRelationship(entryRel);
            }
        } else {
            LOGGER.warn("clinical manifestations are null or empty");
        }
        return problemConcern;
    }
}

