/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.narrative;

import jakarta.xml.bind.JAXBElement;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.narrative.BaseTextGenerator;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.StrucDocTable;
import org.projecthusky.common.hl7cdar2.StrucDocTbody;
import org.projecthusky.common.hl7cdar2.StrucDocThead;
import org.projecthusky.common.hl7cdar2.StrucDocTr;

public class AnnotationTextBuilder
extends BaseTextGenerator {
    private List<POCDMT000040Entry> entries;
    private List<String> notes;

    public AnnotationTextBuilder(List<POCDMT000040Entry> entries, List<String> notes) {
        this.entries = entries;
        this.notes = notes;
    }

    private StrucDocThead getTableHeader() {
        StrucDocThead thead = new StrucDocThead();
        StrucDocTr tr = new StrucDocTr();
        tr.getThOrTd().add(this.getTableHeaderCell("Befundbewertung", null));
        thead.getTr().add(tr);
        return thead;
    }

    private StrucDocTable getBody() {
        StrucDocTable table = new StrucDocTable();
        StrucDocTbody body = new StrucDocTbody();
        int index = 0;
        for (POCDMT000040Entry entry : this.entries) {
            if (entry == null || entry.getAct() == null) continue;
            String reference = entry.getAct().getText().getReference().getMergedXmlMixed();
            StrucDocTr tr = new StrucDocTr();
            tr.getThOrTd().add(this.getCellTdWithContent(this.notes.get(index), reference));
            body.getTr().add(tr);
            ++index;
        }
        table.setThead(this.getTableHeader());
        table.getTbody().add(body);
        return table;
    }

    public List<JAXBElement<StrucDocTable>> getTablesFromCda() {
        LinkedList<JAXBElement<StrucDocTable>> tables = new LinkedList<JAXBElement<StrucDocTable>>();
        tables.add(new JAXBElement(new QName("urn:hl7-org:v3", "table"), StrucDocTable.class, (Object)this.getBody()));
        return tables;
    }
}

