/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.narrative;

import jakarta.xml.bind.JAXBElement;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.narrative.BaseTextGenerator;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.StrucDocTable;
import org.projecthusky.common.hl7cdar2.StrucDocTbody;
import org.projecthusky.common.hl7cdar2.StrucDocThead;
import org.projecthusky.common.hl7cdar2.StrucDocTr;

public class KonsUeberwGrundNarrativeTextGenerator
extends BaseTextGenerator {
    private List<POCDMT000040Entry> entries;

    public KonsUeberwGrundNarrativeTextGenerator(List<POCDMT000040Entry> entries) {
        this.entries = entries;
    }

    private StrucDocThead getTableHeader() {
        StrucDocThead thead = new StrucDocThead();
        StrucDocTr tr = new StrucDocTr();
        tr.getThOrTd().add(this.getTableHeaderCell("Code", null));
        tr.getThOrTd().add(this.getTableHeaderCell("Zusatzinformation", null));
        thead.getTr().add(tr);
        return thead;
    }

    private StrucDocTable getBody(POCDMT000040Act act) {
        StrucDocTable table = new StrucDocTable();
        StrucDocTbody body = new StrucDocTbody();
        if (act != null) {
            for (POCDMT000040EntryRelationship entryRel : act.getEntryRelationship()) {
                if (entryRel == null || entryRel.getObservation() == null) continue;
                int index = 0;
                for (ANY value : entryRel.getObservation().getValue()) {
                    CD cdValue = (CD)value;
                    StrucDocTr tr = new StrucDocTr();
                    tr.setID(String.format("classification-%d", index));
                    tr.getThOrTd().add(this.getCellTd(cdValue.getCodeSystemName() + ": " + cdValue.getCode()));
                    tr.getThOrTd().add(this.getCellTd(cdValue.getDisplayName()));
                    body.getTr().add(tr);
                    ++index;
                }
            }
        }
        table.setThead(this.getTableHeader());
        table.getTbody().add(body);
        return table;
    }

    public List<JAXBElement<StrucDocTable>> getTablesFromCda() {
        LinkedList<JAXBElement<StrucDocTable>> tables = new LinkedList<JAXBElement<StrucDocTable>>();
        for (POCDMT000040Entry entry : this.entries) {
            if (entry == null || entry.getAct() == null) continue;
            tables.add((JAXBElement<StrucDocTable>)new JAXBElement(new QName("urn:hl7-org:v3", "table"), StrucDocTable.class, (Object)this.getBody(entry.getAct())));
        }
        return tables;
    }
}

