/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.narrative;

import jakarta.xml.bind.JAXBElement;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.narrative.BaseTextGenerator;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.ON;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Participant2;
import org.projecthusky.common.hl7cdar2.POCDMT000040Performer2;
import org.projecthusky.common.hl7cdar2.StrucDocTable;
import org.projecthusky.common.hl7cdar2.StrucDocTbody;
import org.projecthusky.common.hl7cdar2.StrucDocText;
import org.projecthusky.common.hl7cdar2.StrucDocThead;
import org.projecthusky.common.hl7cdar2.StrucDocTr;
import org.projecthusky.common.model.Name;
import org.projecthusky.common.utils.time.Hl7Dtm;

public class SpecimenNarrativeTextGenerator
extends BaseTextGenerator {
    private List<POCDMT000040Entry> entries;

    public SpecimenNarrativeTextGenerator(List<POCDMT000040Entry> entries) {
        this.entries = entries;
    }

    private StrucDocTbody getBody(List<POCDMT000040EntryRelationship> entries) {
        StrucDocTbody body = new StrucDocTbody();
        for (POCDMT000040EntryRelationship component : entries) {
            if (component == null || component.getProcedure() == null) continue;
            StrucDocTr tr = new StrucDocTr();
            if (component.getProcedure().getText() != null && component.getProcedure().getText().getReference() != null && component.getProcedure().getText().getReference().getValue() != null) {
                tr.setID(component.getProcedure().getText().getReference().getValue().replace("#", ""));
            }
            this.addMaterialRows(component, tr);
            this.addSampleRows(component, tr);
            body.getTr().add(tr);
        }
        return body;
    }

    private void addMaterialRows(POCDMT000040EntryRelationship component, StrucDocTr tr) {
        if (!component.getProcedure().getParticipant().isEmpty() && component.getProcedure().getParticipant().get(0) != null && ((POCDMT000040Participant2)component.getProcedure().getParticipant().get(0)).getParticipantRole() != null) {
            if (!((POCDMT000040Participant2)component.getProcedure().getParticipant().get(0)).getParticipantRole().getId().isEmpty()) {
                tr.getThOrTd().add(this.getCellTdId((II)((POCDMT000040Participant2)component.getProcedure().getParticipant().get(0)).getParticipantRole().getId().get(0)));
            }
            if (((POCDMT000040Participant2)component.getProcedure().getParticipant().get(0)).getParticipantRole().getPlayingEntity() != null && ((POCDMT000040Participant2)component.getProcedure().getParticipant().get(0)).getParticipantRole().getPlayingEntity().getCode() != null) {
                tr.getThOrTd().add(this.getCellTdCode((CD)((POCDMT000040Participant2)component.getProcedure().getParticipant().get(0)).getParticipantRole().getPlayingEntity().getCode()));
            }
        }
    }

    private void addSampleRows(POCDMT000040EntryRelationship component, StrucDocTr tr) {
        String date;
        Hl7Dtm hl7Dtm;
        if (component.getProcedure().getEffectiveTime() != null && component.getProcedure().getEffectiveTime().getValue() != null) {
            hl7Dtm = Hl7Dtm.fromHl7((String)component.getProcedure().getEffectiveTime().getValue());
            date = hl7Dtm.getDateTime().format(DateTimeFormatter.ofPattern("dd.MM.yyyy"));
            tr.getThOrTd().add(this.getCellTd(date));
        }
        if (!component.getProcedure().getPerformer().isEmpty() && component.getProcedure().getPerformer().get(0) != null && ((POCDMT000040Performer2)component.getProcedure().getPerformer().get(0)).getAssignedEntity() != null && ((POCDMT000040Performer2)component.getProcedure().getPerformer().get(0)).getAssignedEntity().getRepresentedOrganization() != null) {
            Name name = new Name((ON)((POCDMT000040Performer2)component.getProcedure().getPerformer().get(0)).getAssignedEntity().getRepresentedOrganization().getName().get(0));
            tr.getThOrTd().add(this.getCellTd(name.getName()));
        }
        if (!component.getProcedure().getEntryRelationship().isEmpty() && component.getProcedure().getEntryRelationship().get(0) != null && ((POCDMT000040EntryRelationship)component.getProcedure().getEntryRelationship().get(0)).getAct() != null && ((POCDMT000040EntryRelationship)component.getProcedure().getEntryRelationship().get(0)).getAct().getEffectiveTime() != null && ((POCDMT000040EntryRelationship)component.getProcedure().getEntryRelationship().get(0)).getAct().getEffectiveTime().getValue() != null) {
            hl7Dtm = Hl7Dtm.fromHl7((String)((POCDMT000040EntryRelationship)component.getProcedure().getEntryRelationship().get(0)).getAct().getEffectiveTime().getValue());
            date = hl7Dtm.getDateTime().format(DateTimeFormatter.ofPattern("dd.MM.yyyy"));
            tr.getThOrTd().add(this.getCellTd(date));
        }
    }

    private StrucDocThead getTableHeader() {
        StrucDocThead thead = new StrucDocThead();
        StrucDocTr tr = new StrucDocTr();
        tr.getThOrTd().add(this.getTableHeaderCell("Material-ID", "xELGA_colw:15"));
        tr.getThOrTd().add(this.getTableHeaderCell("Untersuchtes Material", "xELGA_colw:14"));
        tr.getThOrTd().add(this.getTableHeaderCell("Probenentnahme", "xELGA_colw:10"));
        tr.getThOrTd().add(this.getTableHeaderCell("Probenentnahme durch", "xELGA_colw:17"));
        tr.getThOrTd().add(this.getTableHeaderCell("Probeneingang", "xELGA_colw:10"));
        thead.getTr().add(tr);
        return thead;
    }

    public StrucDocTable getTable(List<POCDMT000040EntryRelationship> entries) {
        StrucDocTable table = new StrucDocTable();
        table.setThead(this.getTableHeader());
        table.getTbody().add(this.getBody(entries));
        return table;
    }

    public StrucDocText getText() {
        StrucDocText text = new StrucDocText();
        for (POCDMT000040Entry entry : this.entries) {
            if (entry == null || entry.getAct() == null || entry.getAct().getEntryRelationship().isEmpty()) continue;
            text.getContent().add(new JAXBElement(new QName("urn:hl7-org:v3", "table"), StrucDocTable.class, (Object)this.getTable(entry.getAct().getEntryRelationship())));
        }
        return text;
    }
}

