/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.buildtools.smallryeopenapi;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.JarIndexer;
import org.jboss.jandex.Result;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.projectnessie.buildtools.smallryeopenapi.DependencyIndexCreator;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u0017\u001a\u00020\u00182\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001c0\u001b0\u001aH\u0002J8\u0010\u001d\u001a\u00020\f2\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001c0\u001b0\u001e2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006!"}, d2={"Lorg/projectnessie/buildtools/smallryeopenapi/DependencyIndexCreator;", "", "logger", "Lorg/gradle/api/logging/Logger;", "(Lorg/gradle/api/logging/Logger;)V", "getLogger", "()Lorg/gradle/api/logging/Logger;", "buildGAVCTString", "", "artifact", "Lorg/gradle/api/artifacts/PublishArtifact;", "createIndex", "Lorg/jboss/jandex/IndexView;", "allArtifacts", "Lorg/gradle/api/artifacts/PublishArtifactSet;", "classesDirs", "Lorg/gradle/api/file/FileCollection;", "indexModuleClasses", "Lorg/jboss/jandex/Index;", "file", "Ljava/io/File;", "isIgnored", "", "printIndexDurations", "", "indexDurations", "", "", "Ljava/time/Duration;", "timeAndCache", "", "callable", "Ljava/util/concurrent/Callable;", "smallrye-openapi"})
public final class DependencyIndexCreator {
    @NotNull
    private final Logger logger;

    @NotNull
    public final IndexView createIndex(@Nullable PublishArtifactSet allArtifacts, @NotNull FileCollection classesDirs) throws Exception {
        Intrinsics.checkNotNullParameter((Object)classesDirs, (String)"classesDirs");
        List indexDurations = new ArrayList();
        List artifacts = new ArrayList();
        if (allArtifacts != null) {
            artifacts.addAll((Collection)allArtifacts);
        }
        List indexes = new ArrayList();
        Set set = classesDirs.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"classesDirs.files");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File f = (File)element$iv;
            boolean bl = false;
            File file = f;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"f");
            indexes.add(this.indexModuleClasses(file));
        }
        for (PublishArtifact artifact : artifacts) {
            if (this.isIgnored(artifact)) continue;
            try {
                File file = artifact.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"artifact.file");
                if (file.isDirectory()) {
                    indexes.add(this.indexModuleClasses(artifact));
                    continue;
                }
                File file2 = artifact.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"artifact.file");
                String string = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.file.name");
                if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
                IndexView artifactIndex2 = this.timeAndCache(indexDurations, artifact, new Callable(artifact){
                    final /* synthetic */ PublishArtifact $artifact;

                    public final IndexView call() {
                        Result result;
                        Result result2 = result = JarIndexer.createJarIndex((File)this.$artifact.getFile(), (Indexer)new Indexer(), (boolean)false, (boolean)false, (boolean)false);
                        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
                        return (IndexView)result2.getIndex();
                    }
                    {
                        this.$artifact = publishArtifact;
                    }
                });
                indexes.add(artifactIndex2);
            }
            catch (IOException e) {
                File file = artifact.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"artifact.file");
                this.logger.error("Can't compute index of " + file.getAbsolutePath().toString() + ", skipping", (Throwable)e);
            }
            catch (ExecutionException e) {
                File file = artifact.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"artifact.file");
                this.logger.error("Can't compute index of " + file.getAbsolutePath().toString() + ", skipping", (Throwable)e);
            }
        }
        this.printIndexDurations(indexDurations);
        CompositeIndex compositeIndex = CompositeIndex.create((Collection)indexes);
        Intrinsics.checkNotNullExpressionValue((Object)compositeIndex, (String)"CompositeIndex.create(indexes)");
        return (IndexView)compositeIndex;
    }

    private final void printIndexDurations(List<? extends Map.Entry<? extends PublishArtifact, Duration>> indexDurations) {
        this.logger.isDebugEnabled();
    }

    private final boolean isIgnored(PublishArtifact artifact) {
        return false;
    }

    private final IndexView timeAndCache(List<Map.Entry<PublishArtifact, Duration>> indexDurations, PublishArtifact artifact, Callable<IndexView> callable) throws Exception {
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"LocalDateTime.now()");
        LocalDateTime start = localDateTime;
        IndexView indexView = callable.call();
        Intrinsics.checkNotNullExpressionValue((Object)indexView, (String)"callable.call()");
        IndexView result = indexView;
        LocalDateTime localDateTime2 = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"LocalDateTime.now()");
        LocalDateTime end = localDateTime2;
        Duration duration = Duration.between(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.between(start, end)");
        Duration duration2 = duration;
        indexDurations.add(new AbstractMap.SimpleEntry<PublishArtifact, Duration>(artifact, duration2));
        return result;
    }

    private final Index indexModuleClasses(PublishArtifact artifact) throws IOException {
        File file = artifact.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"artifact.file");
        return this.indexModuleClasses(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Index indexModuleClasses(File file) throws IOException {
        Indexer indexer = new Indexer();
        if (file.exists()) {
            AutoCloseable autoCloseable = Files.walk(file.toPath(), new FileVisitOption[0]);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl3 = false;
                List list = stream.filter(indexModuleClasses.1.classFiles.1.INSTANCE).collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(list, (String)"stream.filter { path -> \u2026lect(Collectors.toList())");
                List classFiles2 = list;
                for (Path path : classFiles2) {
                    indexer.index(Files.newInputStream(path, new OpenOption[0]));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        Index index = indexer.complete();
        Intrinsics.checkNotNullExpressionValue((Object)index, (String)"indexer.complete()");
        return index;
    }

    private final String buildGAVCTString(PublishArtifact artifact) {
        return artifact.getName() + ":" + artifact.getClassifier() + ":" + artifact.getType();
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public DependencyIndexCreator(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }
}

