/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.nessie.NessieExtCatalog;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.jaxrs.ext.NessieJaxRsExtension;
import org.projectnessie.jaxrs.ext.NessieUri;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.inmem.InmemoryTestConnectionProviderSource;
import org.projectnessie.versioned.persist.tests.extension.DatabaseAdapterExtension;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapter;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapterName;
import org.projectnessie.versioned.persist.tests.extension.NessieExternalDatabase;

@ExtendWith(value={DatabaseAdapterExtension.class})
@NessieDbAdapterName(value="In-Memory")
@NessieExternalDatabase(value=InmemoryTestConnectionProviderSource.class)
public class BaseIcebergTest {
    @NessieDbAdapter
    static DatabaseAdapter databaseAdapter;
    @RegisterExtension
    static NessieJaxRsExtension server;
    @TempDir
    public Path temp;
    protected NessieExtCatalog catalog;
    protected NessieApiV1 api;
    protected Configuration hadoopConfig;
    protected final String branch;
    protected String uri;

    public BaseIcebergTest(String branch) {
        this.branch = branch;
    }

    private void resetData() throws NessieConflictException, NessieNotFoundException {
        for (Reference r : this.api.getAllReferences().get().getReferences()) {
            if (r instanceof Branch) {
                ((DeleteBranchBuilder)this.api.deleteBranch().branch((Branch)r)).delete();
                continue;
            }
            ((DeleteTagBuilder)this.api.deleteTag().tag((Tag)r)).delete();
        }
        this.api.createReference().reference((Reference)Branch.of((String)"main", null)).create();
    }

    @BeforeEach
    public void beforeEach(@NessieUri URI x) throws IOException {
        this.uri = x.toString();
        this.api = (NessieApiV1)((HttpClientBuilder)HttpClientBuilder.builder().withUri(this.uri)).build(NessieApiV1.class);
        this.resetData();
        try {
            this.api.createReference().reference((Reference)Branch.of((String)this.branch, null)).create();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hadoopConfig = new Configuration();
        this.catalog = this.initCatalog(this.branch);
    }

    NessieExtCatalog initCatalog(String ref) {
        NessieExtCatalog newCatalog = new NessieExtCatalog();
        newCatalog.setConf(this.hadoopConfig);
        newCatalog.initialize("nessie", (Map)ImmutableMap.of((Object)"ref", (Object)ref, (Object)"uri", (Object)this.uri, (Object)"auth-type", (Object)"NONE", (Object)"warehouse", (Object)this.temp.toUri().toString()));
        return newCatalog;
    }

    protected static Schema schema(int count) {
        ArrayList fields = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            fields.add(Types.NestedField.required((int)i, (String)("id" + i), (Type)Types.LongType.get()));
        }
        return new Schema(Types.StructType.of((List)fields).fields());
    }

    @AfterEach
    public void afterEach() throws Exception {
        try {
            if (this.catalog != null) {
                this.catalog.close();
            }
            this.api.close();
        }
        finally {
            this.catalog = null;
            this.api = null;
            this.hadoopConfig = null;
        }
    }

    static String writeRecordsToFile(Table table, Schema schema, String filename, List<GenericData.Record> records) throws IOException {
        String fileLocation = table.location().replace("file:", "") + String.format("/data/%s.avro", filename);
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((String)fileLocation)).schema(schema).named("test").build();){
            for (GenericData.Record rec : records) {
                writer.add((Object)rec);
            }
        }
        return fileLocation;
    }

    static {
        server = new NessieJaxRsExtension(() -> databaseAdapter);
    }
}

