/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import org.apache.iceberg.Files;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.view.BaseView;
import org.apache.iceberg.view.Version;
import org.apache.iceberg.view.ViewDefinition;
import org.apache.iceberg.view.ViewOperations;
import org.apache.iceberg.view.ViewUtils;
import org.apache.iceberg.view.ViewVersionMetadata;

public class TestViews {
    private static final Map<String, ViewVersionMetadata> METADATA = Maps.newHashMap();
    private static final Map<String, Integer> VERSIONS = Maps.newHashMap();

    private TestViews() {
    }

    public static void create(File temp, String name, ViewDefinition viewDefinition, Map<String, String> properties) {
        TestViewOperations ops = new TestViewOperations(name, temp);
        if (ops.current() != null) {
            throw new AlreadyExistsException("View %s already exists at location: %s", new Object[]{name, temp});
        }
        int parentId = -1;
        properties.put("genie_id", "test genie-id");
        properties.put("engine_version", "TestEngine");
        ViewUtils.doCommit((String)"create", properties, (int)1, (int)parentId, (ViewDefinition)viewDefinition, (String)"", (ViewOperations)ops, null);
    }

    public static ViewVersionMetadata loadViewVersionMetadata(File temp, String name) {
        TestViewOperations ops = new TestViewOperations(name, temp);
        if (ops.current() != null) {
            return ops.current();
        }
        throw new NotFoundException("View '%s' not found", new Object[]{name});
    }

    public static BaseView load(File temp, String name) {
        TestViewOperations ops = new TestViewOperations(name, temp);
        return new BaseView((ViewOperations)ops, name);
    }

    public static void replace(File temp, String name, ViewDefinition viewDefinition, Map<String, String> properties) {
        ViewVersionMetadata prevViewVersionMetadata = TestViews.loadViewVersionMetadata(temp, name);
        TestViewOperations ops = new TestViewOperations(name, temp);
        if (ops.current() == null) {
            throw new NotFoundException("View %s does not exist at location: %s", new Object[]{name, temp});
        }
        Preconditions.checkState((prevViewVersionMetadata.versions().size() > 0 ? 1 : 0) != 0, (Object)"Version history not found");
        int parentId = prevViewVersionMetadata.currentVersionId();
        String location = prevViewVersionMetadata.location();
        properties.put("genie_id", "test genie-id");
        properties.put("engine_version", "TestEngine");
        ViewUtils.doCommit((String)"replace", properties, (int)(parentId + 1), (int)parentId, (ViewDefinition)viewDefinition, (String)location, (ViewOperations)ops, (ViewVersionMetadata)prevViewVersionMetadata);
    }

    public static void drop(String name, File temp) {
        TestViewOperations ops = new TestViewOperations(name, temp);
        if (ops.current() != null) {
            ops.drop(name);
            return;
        }
        throw new NotFoundException("View '%s' not found", new Object[]{name});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearTables() {
        Map<String, ViewVersionMetadata> map = METADATA;
        synchronized (map) {
            METADATA.clear();
            VERSIONS.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ViewVersionMetadata readMetadata(String viewName) {
        Map<String, ViewVersionMetadata> map = METADATA;
        synchronized (map) {
            return METADATA.get(viewName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Integer metadataVersion(String viewName) {
        Map<String, ViewVersionMetadata> map = METADATA;
        synchronized (map) {
            return VERSIONS.get(viewName);
        }
    }

    static class LocalFileIO
    implements FileIO {
        LocalFileIO() {
        }

        public InputFile newInputFile(String path) {
            return Files.localInput((String)path);
        }

        public OutputFile newOutputFile(String path) {
            return Files.localOutput((String)path);
        }

        public void deleteFile(String path) {
            if (!new File(path).delete()) {
                throw new RuntimeIOException("Failed to delete file: %s", new Object[]{path});
            }
        }
    }

    public static class TestViewOperations
    implements ViewOperations {
        private final String viewName;
        private final File metadata;
        private ViewVersionMetadata current = null;
        private long lastVersionId = 0L;

        public TestViewOperations(String viewName, File location) {
            this.viewName = viewName;
            this.metadata = new File(location, "metadata");
            this.metadata.mkdirs();
            this.refresh();
            if (this.current != null) {
                for (Version version : this.current.versions()) {
                    this.lastVersionId = Math.max(this.lastVersionId, (long)version.versionId());
                }
            } else {
                this.lastVersionId = 0L;
            }
        }

        public ViewVersionMetadata current() {
            return this.current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ViewVersionMetadata refresh() {
            Map map = METADATA;
            synchronized (map) {
                this.current = (ViewVersionMetadata)METADATA.get(this.viewName);
            }
            return this.current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit(ViewVersionMetadata base, ViewVersionMetadata updatedMetadata, Map<String, String> properties) {
            if (base != this.current) {
                throw new CommitFailedException("Cannot commit changes based on stale metadata", new Object[0]);
            }
            Map map = METADATA;
            synchronized (map) {
                this.refresh();
                if (base != this.current) {
                    throw new CommitFailedException("Commit failed: table was updated at %d", new Object[]{this.current.currentVersion().timestampMillis()});
                }
                Integer version = (Integer)VERSIONS.get(this.viewName);
                VERSIONS.put(this.viewName, version == null ? 0 : version + 1);
                METADATA.put(this.viewName, updatedMetadata);
                this.current = updatedMetadata;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(String name) {
            Map map = METADATA;
            synchronized (map) {
                METADATA.remove(name);
                VERSIONS.remove(name);
            }
        }

        public FileIO io() {
            return new LocalFileIO();
        }
    }
}

