/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.view.TestViewBase;
import org.apache.iceberg.view.TestViews;
import org.apache.iceberg.view.ViewDefinition;
import org.apache.iceberg.view.ViewVersionMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestViewRetainComments
extends TestViewBase {
    @Test
    public void testViewRetainComments() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"c1", (Type)Types.IntegerType.get(), (String)"c1 comment"), Types.NestedField.required((int)4, (String)"c2", (Type)Types.StringType.get(), (String)"c2 comment")});
        ViewDefinition viewMetadata = ViewDefinition.of((String)"select sum(1) from base_tab", (Schema)schema, (String)"", new ArrayList());
        TestViews.replace(this.metadataDir, "test", viewMetadata, new HashMap<String, String>());
        ViewVersionMetadata viewVersionMetadata = TestViews.loadViewVersionMetadata(this.metadataDir, "test");
        ViewDefinition oldViewMetadata = viewVersionMetadata.definition();
        Assertions.assertEquals((Object)oldViewMetadata.schema().toString(), (Object)schema.toString());
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"c1", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"intData", (Type)Types.IntegerType.get())});
        viewMetadata = ViewDefinition.of((String)"select c1, intData from base_tab", (Schema)newSchema, (String)"new catalog", new ArrayList());
        TestViews.replace(this.metadataDir, "test", viewMetadata, new HashMap<String, String>());
        viewVersionMetadata = TestViews.loadViewVersionMetadata(this.metadataDir, "test");
        oldViewMetadata = viewVersionMetadata.definition();
        Assertions.assertEquals((Object)((Types.NestedField)oldViewMetadata.schema().columns().get(0)).doc(), (Object)"c1 comment");
        Assertions.assertEquals((Object)((Types.NestedField)oldViewMetadata.schema().columns().get(1)).doc(), null);
        Assertions.assertEquals((Object)oldViewMetadata.sessionCatalog(), (Object)"new catalog");
        Assertions.assertEquals(viewVersionMetadata.currentVersion().summary().properties().get("engine_version"), (Object)"TestEngine");
        schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"c1", (Type)Types.IntegerType.get(), (String)"c1 comment"), Types.NestedField.required((int)4, (String)"intData", (Type)Types.StringType.get(), (String)"c2 comment")});
        viewMetadata = ViewDefinition.of((String)"select sum(1) from base_tab", (Schema)schema, (String)"", new ArrayList());
        TestViews.replace(this.metadataDir, "test", viewMetadata, new HashMap<String, String>());
        newSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"c1", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"intData", (Type)Types.IntegerType.get(), (String)"")});
        viewMetadata = ViewDefinition.of((String)"select c1, intData from base_tab", (Schema)newSchema, (String)"new catalog", new ArrayList());
        TestViews.replace(this.metadataDir, "test", viewMetadata, new HashMap<String, String>());
        viewVersionMetadata = TestViews.loadViewVersionMetadata(this.metadataDir, "test");
        oldViewMetadata = viewVersionMetadata.definition();
        Assertions.assertEquals((Object)((Types.NestedField)oldViewMetadata.schema().columns().get(0)).doc(), (Object)"c1 comment");
        Assertions.assertEquals((Object)((Types.NestedField)oldViewMetadata.schema().columns().get(0)).isOptional(), (Object)true);
        Assertions.assertEquals((Object)((Types.NestedField)oldViewMetadata.schema().columns().get(1)).doc(), (Object)"");
    }
}

