/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.view.BaseVersion;
import org.apache.iceberg.view.UpdateComment;
import org.apache.iceberg.view.VersionSummary;
import org.apache.iceberg.view.ViewDefinition;
import org.apache.iceberg.view.ViewOperations;
import org.apache.iceberg.view.ViewVersionMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentUpdate
implements UpdateComment {
    private static final Logger LOG = LoggerFactory.getLogger(CommentUpdate.class);
    private final ViewOperations ops;
    private final ViewVersionMetadata base;
    private final Schema schema;
    private final Map<Integer, Types.NestedField> updates = Maps.newHashMap();

    public CommentUpdate(ViewOperations ops) {
        this.ops = ops;
        this.base = ops.current();
        this.schema = this.base.definition().schema();
    }

    @Override
    public UpdateComment updateColumnDoc(String name, String doc) {
        Types.NestedField field = this.schema.findField(name);
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot update missing column: %s", (Object)name);
        int fieldId = field.fieldId();
        this.updates.put(fieldId, Types.NestedField.required((int)fieldId, (String)field.name(), (Type)field.type(), (String)doc));
        return this;
    }

    public Schema apply() {
        return CommentUpdate.applyChanges(this.schema, this.updates);
    }

    public void commit() {
        ViewDefinition baseDefinition = this.base.definition();
        ViewDefinition viewDefinition = ViewDefinition.of(baseDefinition.sql(), this.apply(), baseDefinition.sessionCatalog(), baseDefinition.sessionNamespace());
        HashMap<String, String> summaryProps = new HashMap<String, String>();
        summaryProps.put("operation", "alter-comment");
        summaryProps.put("genie_id", "N/A");
        summaryProps.put("engine_version", "N/A");
        VersionSummary summary = new VersionSummary(summaryProps);
        BaseVersion version = new BaseVersion(this.base.currentVersionId() + 1, this.base.currentVersionId(), System.currentTimeMillis(), summary, viewDefinition);
        ViewVersionMetadata update = ViewVersionMetadata.newViewVersionMetadata(version, this.base.location(), viewDefinition, this.base, this.base.properties());
        this.ops.commit(this.base, update, new HashMap<String, String>());
    }

    private static Schema applyChanges(Schema schema, Map<Integer, Types.NestedField> updates) {
        Types.StructType struct = ((Type)TypeUtil.visit((Schema)schema, (TypeUtil.SchemaVisitor)new ApplyChanges(updates))).asNestedType().asStructType();
        return new Schema(struct.fields());
    }

    private static class ApplyChanges
    extends TypeUtil.SchemaVisitor<Type> {
        private final Map<Integer, Types.NestedField> updates;

        private ApplyChanges(Map<Integer, Types.NestedField> updates) {
            this.updates = updates;
        }

        public Type schema(Schema schema, Type structResult) {
            return structResult;
        }

        public Type struct(Types.StructType struct, List<Type> fieldResults) {
            boolean hasChange = false;
            ArrayList newFields = Lists.newArrayListWithExpectedSize((int)fieldResults.size());
            for (int i = 0; i < fieldResults.size(); ++i) {
                Type resultType = fieldResults.get(i);
                if (resultType == null) {
                    hasChange = true;
                    continue;
                }
                Types.NestedField field = (Types.NestedField)struct.fields().get(i);
                String name = field.name();
                String doc = field.doc();
                Types.NestedField update = this.updates.get(field.fieldId());
                if (update != null) {
                    name = update.name();
                    doc = update.doc();
                }
                if (!name.equals(field.name()) || field.type() != resultType || !Objects.equals(doc, field.doc())) {
                    hasChange = true;
                    if (field.isOptional()) {
                        newFields.add(Types.NestedField.optional((int)field.fieldId(), (String)name, (Type)resultType, (String)doc));
                        continue;
                    }
                    newFields.add(Types.NestedField.required((int)field.fieldId(), (String)name, (Type)resultType, (String)doc));
                    continue;
                }
                newFields.add(field);
            }
            if (hasChange) {
                return Types.StructType.of((List)newFields);
            }
            return struct;
        }

        public Type field(Types.NestedField field, Type fieldResult) {
            Types.NestedField update = this.updates.get(field.fieldId());
            if (update != null && update.type() != field.type()) {
                return update.type();
            }
            return fieldResult;
        }

        public Type list(Types.ListType list, Type result) {
            Type elementResult = this.field((Types.NestedField)list.fields().get(0), result);
            if (elementResult == null) {
                throw new IllegalArgumentException("Cannot delete element type from list: " + list);
            }
            if (list.elementType() == elementResult) {
                return list;
            }
            if (list.isElementOptional()) {
                return Types.ListType.ofOptional((int)list.elementId(), (Type)elementResult);
            }
            return Types.ListType.ofRequired((int)list.elementId(), (Type)elementResult);
        }

        public Type map(Types.MapType map, Type keyResult, Type valResult) {
            int keyId = ((Types.NestedField)map.fields().get(0)).fieldId();
            if (this.updates.containsKey(keyId)) {
                throw new IllegalArgumentException("Cannot update map keys: " + map);
            }
            if (!map.keyType().equals(keyResult)) {
                throw new IllegalArgumentException("Cannot alter map keys: " + map);
            }
            Type valueResult = this.field((Types.NestedField)map.fields().get(1), valResult);
            if (valueResult == null) {
                throw new IllegalArgumentException("Cannot delete value type from map: " + map);
            }
            if (map.valueType() == valueResult) {
                return map;
            }
            if (map.isValueOptional()) {
                return Types.MapType.ofOptional((int)map.keyId(), (int)map.valueId(), (Type)map.keyType(), (Type)valueResult);
            }
            return Types.MapType.ofRequired((int)map.keyId(), (int)map.valueId(), (Type)map.keyType(), (Type)valueResult);
        }

        public Type primitive(Type.PrimitiveType primitive) {
            return primitive;
        }
    }
}

