/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.common.collect.Iterators;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.view.BaseView;
import org.apache.iceberg.view.TestViews;
import org.apache.iceberg.view.ViewDefinition;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;

public class TestViewBase {
    public static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"c1", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"c2", (Type)Types.StringType.get())});
    public static final String SQL = "select c1, c2 from base_tab";
    File tableDir = null;
    File metadataDir = null;

    @BeforeEach
    public void setupTable(@TempDir File dir) throws Exception {
        this.tableDir = dir;
        this.metadataDir = new File(this.tableDir, "metadata");
        this.create(SCHEMA);
    }

    @AfterEach
    public void cleanupTables() {
        TestViews.drop("test", this.metadataDir);
        TestViews.clearTables();
    }

    private BaseView create(Schema schema) {
        ViewDefinition viewMetadata = ViewDefinition.of((String)SQL, (Schema)SCHEMA, (String)"", new ArrayList());
        TestViews.create(this.tableDir, "test", viewMetadata, new HashMap<String, String>());
        return TestViews.load(this.tableDir, "test");
    }

    BaseView load() {
        return TestViews.load(this.tableDir, "test");
    }

    Integer version() {
        return TestViews.metadataVersion("test");
    }

    static Iterator<Long> ids(Long ... ids) {
        return Iterators.forArray((Object[])ids);
    }

    static Iterator<DataFile> files(DataFile ... files) {
        return Iterators.forArray((Object[])files);
    }

    static Iterator<DataFile> files(ManifestFile manifest) {
        return null;
    }
}

