/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.nessie.BaseIcebergTest;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.view.CommentUpdate;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewDefinition;
import org.apache.iceberg.view.ViewOperations;
import org.apache.iceberg.view.ViewUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.jaxrs.ext.NessieUri;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergView;

public class TestNessieIcebergViews
extends BaseIcebergTest {
    private static final String BRANCH = "iceberg-view-test";
    private static final String SQL = "select id from tbl";
    private static final String SQL_ALTERED = "select id, data from tbl";
    private static final String DB_NAME = "db";
    private static final String TABLE_NAME = "tbl";
    public static final String CATALOG_NAME = "nessie";
    private static final TableIdentifier VIEW_IDENTIFIER = TableIdentifier.of((String[])new String[]{"nessie", "db", "view_name"});
    private static final TableIdentifier TABLE_IDENTIFIER = TableIdentifier.of((String[])new String[]{"db", "tbl"});
    private static final Schema SCHEMA = new Schema(Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())}).fields());
    private Path tableLocation;

    public TestNessieIcebergViews() {
        super(BRANCH);
    }

    @Override
    @BeforeEach
    public void beforeEach(@NessieUri URI uri) throws IOException {
        super.beforeEach(uri);
        Table table = this.catalog.createTable(TABLE_IDENTIFIER, SCHEMA);
        this.tableLocation = new Path(table.location());
        this.catalog.create(VIEW_IDENTIFIER.toString(), ViewDefinition.of((String)SQL, (Schema)SCHEMA, (String)CATALOG_NAME, new ArrayList()), Collections.emptyMap());
    }

    @Override
    @AfterEach
    public void afterEach() throws Exception {
        if (this.tableLocation != null) {
            this.tableLocation.getFileSystem(this.hadoopConfig).delete(this.tableLocation, true);
            this.catalog.refresh();
            this.catalog.dropTable(TABLE_IDENTIFIER, false);
            this.catalog.drop(VIEW_IDENTIFIER.toString());
        }
        super.afterEach();
    }

    @Test
    public void testCreateView() throws IOException {
        ViewDefinition viewDefinition = ViewDefinition.of((String)SQL, (Schema)SCHEMA, (String)CATALOG_NAME, new ArrayList());
        TableIdentifier viewIdentifier = ViewUtils.toCatalogTableIdentifier((String)(VIEW_IDENTIFIER + "x"));
        this.catalog.create(viewIdentifier.toString(), viewDefinition, Collections.emptyMap());
        View icebergView = this.catalog.load(viewIdentifier.toString());
        Assertions.assertThat((Object)icebergView).isNotNull();
        Assertions.assertThat((int)icebergView.currentVersion().versionId()).isEqualTo(1);
        Assertions.assertThat((Object)icebergView.currentVersion().viewDefinition()).isEqualTo((Object)viewDefinition);
        Assertions.assertThat((java.nio.file.Path)Paths.get(this.metadataLocationViews(viewIdentifier.name()), new String[0])).exists();
        ((ListAssert)Assertions.assertThat(this.metadataFilesForViews(viewIdentifier.name())).isNotNull()).hasSize(1);
        this.verifyCommitMetadata();
        Assertions.assertThat((List)((GetCommitLogBuilder)this.api.getCommitLog().refName(BRANCH)).get().getLogEntries()).hasSize(3);
        this.verifyViewInNessie(viewIdentifier, icebergView);
    }

    @Test
    public void testReplaceView() throws NessieNotFoundException {
        this.catalog.loadTable(TABLE_IDENTIFIER).updateSchema().addColumn("mother", (Type)Types.LongType.get()).commit();
        Schema schema = this.catalog.loadTable(TABLE_IDENTIFIER).schema();
        ViewDefinition updatedView = ViewDefinition.of((String)SQL, (Schema)schema, (String)CATALOG_NAME, new ArrayList());
        this.catalog.replace(VIEW_IDENTIFIER.toString(), updatedView, Collections.emptyMap());
        View icebergView = this.catalog.load(VIEW_IDENTIFIER.toString());
        Assertions.assertThat((Object)icebergView).isNotNull();
        Assertions.assertThat((int)icebergView.currentVersion().versionId()).isEqualTo(2);
        Assertions.assertThat((Integer)icebergView.currentVersion().parentId()).isEqualTo(1);
        Assertions.assertThat((Object)icebergView.currentVersion().viewDefinition()).isEqualTo((Object)updatedView);
        Assertions.assertThat((Map)icebergView.properties()).isEmpty();
        Assertions.assertThat((java.nio.file.Path)Paths.get(this.metadataLocationViews(VIEW_IDENTIFIER.name()), new String[0])).exists();
        ((ListAssert)Assertions.assertThat(this.metadataFilesForViews(VIEW_IDENTIFIER.name())).isNotNull()).hasSize(2);
        this.verifyViewInNessie(VIEW_IDENTIFIER, icebergView);
        ViewDefinition updatedSql = ViewDefinition.of((String)SQL_ALTERED, (Schema)schema, (String)CATALOG_NAME, new ArrayList());
        this.catalog.replace(VIEW_IDENTIFIER.toString(), updatedSql, Collections.emptyMap());
        icebergView = this.catalog.load(VIEW_IDENTIFIER.toString());
        Assertions.assertThat((Object)icebergView).isNotNull();
        Assertions.assertThat((int)icebergView.currentVersion().versionId()).isEqualTo(3);
        Assertions.assertThat((Integer)icebergView.currentVersion().parentId()).isEqualTo(2);
        Assertions.assertThat((Object)icebergView.currentVersion().viewDefinition()).isEqualTo((Object)updatedSql);
        Assertions.assertThat((Map)icebergView.properties()).isEmpty();
        Assertions.assertThat((java.nio.file.Path)Paths.get(this.metadataLocationViews(VIEW_IDENTIFIER.name()), new String[0])).exists();
        ((ListAssert)Assertions.assertThat(this.metadataFilesForViews(VIEW_IDENTIFIER.name())).isNotNull()).hasSize(3);
        this.verifyViewInNessie(VIEW_IDENTIFIER, icebergView);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("prop1", "val1");
        properties.put("prop2", "val2");
        this.catalog.replace(VIEW_IDENTIFIER.toString(), ViewDefinition.of((String)SQL_ALTERED, (Schema)schema, (String)CATALOG_NAME, new ArrayList()), properties);
        icebergView = this.catalog.load(VIEW_IDENTIFIER.toString());
        Assertions.assertThat((Object)icebergView).isNotNull();
        Assertions.assertThat((int)icebergView.currentVersion().versionId()).isEqualTo(4);
        Assertions.assertThat((Integer)icebergView.currentVersion().parentId()).isEqualTo(3);
        Assertions.assertThat((Object)icebergView.currentVersion().viewDefinition()).isEqualTo((Object)updatedSql);
        Assertions.assertThat((Map)icebergView.properties()).isEqualTo(properties);
        Assertions.assertThat((java.nio.file.Path)Paths.get(this.metadataLocationViews(VIEW_IDENTIFIER.name()), new String[0])).exists();
        ((ListAssert)Assertions.assertThat(this.metadataFilesForViews(VIEW_IDENTIFIER.name())).isNotNull()).hasSize(4);
        this.verifyCommitMetadata();
        Assertions.assertThat((List)((GetCommitLogBuilder)this.api.getCommitLog().refName(BRANCH)).get().getLogEntries()).hasSize(6);
        this.verifyViewInNessie(VIEW_IDENTIFIER, icebergView);
    }

    @Test
    public void testViewColumnComments() throws NessieNotFoundException {
        CommentUpdate commentUpdate = new CommentUpdate((ViewOperations)this.catalog.getViewCatalog().newViewOps(VIEW_IDENTIFIER));
        String comment = "The column name is id";
        commentUpdate.updateColumnDoc("id", comment);
        Schema schema = commentUpdate.apply();
        Assertions.assertThat((String)schema.findField("id").doc()).isEqualTo(comment);
        comment = comment + " and type is integer";
        commentUpdate.updateColumnDoc("id", comment);
        schema = commentUpdate.apply();
        Assertions.assertThat((String)schema.findField("id").doc()).isEqualTo(comment);
        commentUpdate.commit();
        View icebergView = this.catalog.load(VIEW_IDENTIFIER.toString());
        Assertions.assertThat((Object)icebergView).isNotNull();
        Assertions.assertThat((int)icebergView.currentVersion().versionId()).isEqualTo(2);
        Assertions.assertThat((Integer)icebergView.currentVersion().parentId()).isEqualTo(1);
        Assertions.assertThat((Map)icebergView.properties()).isEmpty();
        Assertions.assertThat((java.nio.file.Path)Paths.get(this.metadataLocationViews(VIEW_IDENTIFIER.name()), new String[0])).exists();
        ((ListAssert)Assertions.assertThat(this.metadataFilesForViews(VIEW_IDENTIFIER.name())).isNotNull()).hasSize(2);
        this.verifyCommitMetadata();
        Assertions.assertThat((List)((GetCommitLogBuilder)this.api.getCommitLog().refName(BRANCH)).get().getLogEntries()).hasSize(3);
        this.verifyViewInNessie(VIEW_IDENTIFIER, icebergView);
    }

    @Test
    public void testDropTableAndView() throws NessieNotFoundException {
        Assertions.assertThat((boolean)this.catalog.tableExists(TABLE_IDENTIFIER)).isTrue();
        Assertions.assertThat((boolean)this.catalog.dropTable(TABLE_IDENTIFIER)).isTrue();
        Assertions.assertThat((boolean)this.catalog.tableExists(TABLE_IDENTIFIER)).isFalse();
        Assertions.assertThat((Object)this.catalog.load(VIEW_IDENTIFIER.toString())).isNotNull();
        this.catalog.drop(VIEW_IDENTIFIER.toString());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.load(VIEW_IDENTIFIER.toString())).isInstanceOf(NotFoundException.class)).hasMessage("View does not exist: " + VIEW_IDENTIFIER);
        this.verifyCommitMetadata();
        Map contentMap = ((GetContentBuilder)this.api.getContent().key(ContentKey.of((String[])VIEW_IDENTIFIER.toString().split("\\."))).refName(BRANCH)).get();
        Assertions.assertThat((Map)contentMap).isEmpty();
    }

    @Test
    public void testRenameViewNotImplemented() {
        Assertions.assertThatThrownBy(() -> this.catalog.getViewCatalog().rename(VIEW_IDENTIFIER.toString(), "new_name")).isInstanceOf(UnsupportedOperationException.class);
    }

    private void verifyCommitMetadata() throws NessieNotFoundException {
        List log = ((GetCommitLogBuilder)this.api.getCommitLog().refName(BRANCH)).get().getLogEntries();
        ((ListAssert)((ListAssert)Assertions.assertThat((List)log).isNotNull()).isNotEmpty()).allSatisfy(logEntry -> {
            CommitMeta commit = logEntry.getCommitMeta();
            ((AbstractStringAssert)Assertions.assertThat((String)commit.getAuthor()).isNotNull()).isNotEmpty();
            Assertions.assertThat((String)commit.getAuthor()).isEqualTo(System.getProperty("user.name"));
            Assertions.assertThat((String)((String)commit.getProperties().get("application-type"))).isEqualTo("iceberg");
            Assertions.assertThat((String)commit.getMessage()).startsWith((CharSequence)"Iceberg");
        });
    }

    private void verifyViewInNessie(TableIdentifier viewIdentifier, View icebergView) throws NessieNotFoundException {
        ContentKey contentKey = ContentKey.of((String[])viewIdentifier.toString().split("\\."));
        Map contentMap = ((GetContentBuilder)this.api.getContent().key(contentKey).refName(BRANCH)).get();
        ((MapAssert)Assertions.assertThat((Map)contentMap).hasSize(1)).containsKey((Object)contentKey);
        Content content = (Content)contentMap.get(contentKey);
        Assertions.assertThat((Optional)content.unwrap(IcebergView.class)).isPresent();
        IcebergView view = (IcebergView)content.unwrap(IcebergView.class).get();
        Assertions.assertThat(this.metadataFilesForViewsPath(viewIdentifier.name())).contains((Object[])new String[]{view.getMetadataLocation()});
        Assertions.assertThat((int)view.getSchemaId()).isEqualTo(icebergView.currentVersion().viewDefinition().schema().schemaId());
        Assertions.assertThat((int)view.getVersionId()).isEqualTo(view.getVersionId());
        Assertions.assertThat((String)view.getSqlText()).isEqualTo(icebergView.currentVersion().viewDefinition().sql());
    }

    private String getTableBasePath(String tableName) {
        String databasePath = this.temp.toString() + "/" + DB_NAME;
        return Paths.get(databasePath, tableName).toAbsolutePath().toString();
    }

    private String getViewBasePath(String viewName) {
        return Paths.get(this.temp.toString() + "/" + CATALOG_NAME + "." + DB_NAME, viewName).toAbsolutePath().toString();
    }

    private String metadataLocationViews(String viewName) {
        return Paths.get(this.getViewBasePath(viewName), "metadata").toString();
    }

    private List<String> metadataFilesForViews(String viewName) {
        return Arrays.stream(new File(this.metadataLocationViews(viewName)).listFiles()).map(File::getAbsolutePath).filter(f -> f.endsWith(".metadata.json")).collect(Collectors.toList());
    }

    private List<String> metadataFilesForViewsPath(String viewName) {
        return this.metadataFilesForViews(viewName).stream().map(x -> String.format("file://%s", x)).collect(Collectors.toList());
    }

    private String metadataLocation(String tableName) {
        return Paths.get(this.getTableBasePath(tableName), "metadata").toString();
    }
}

