/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.util.JsonUtil;
import org.apache.iceberg.view.BaseVersion;
import org.apache.iceberg.view.Version;
import org.apache.iceberg.view.VersionSummary;
import org.apache.iceberg.view.ViewDefinition;
import org.apache.iceberg.view.ViewDefinitionParser;

public class VersionParser {
    private static final String VERSION_ID = "version-id";
    private static final String PARENT_VERSION_ID = "parent-version-id";
    private static final String TIMESTAMP_MS = "timestamp-ms";
    private static final String SUMMARY = "summary";
    private static final String OPERATION = "operation";
    private static final String VIEW_DEFINITION = "view-definition";

    static void toJson(Version version, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField(VERSION_ID, version.versionId());
        if (version.parentId() != null) {
            generator.writeNumberField(PARENT_VERSION_ID, version.parentId().intValue());
        }
        generator.writeNumberField(TIMESTAMP_MS, version.timestampMillis());
        if (version.summary() != null && version.summary().properties().size() > 0) {
            generator.writeObjectFieldStart(SUMMARY);
            generator.writeStringField(OPERATION, version.summary().properties.get(OPERATION) == null ? "N/A" : version.summary().properties.get(OPERATION));
            generator.writeStringField("genie_id", version.summary().properties.get("genie_id") == null ? "N/A" : version.summary().properties.get("genie_id"));
            generator.writeStringField("engine_version", version.summary().properties.get("engine_version") == null ? "N/A" : version.summary().properties.get("engine_version"));
            generator.writeEndObject();
        }
        generator.writeFieldName(VIEW_DEFINITION);
        ViewDefinitionParser.toJson(version.viewDefinition(), generator);
        generator.writeEndObject();
    }

    public static String toJson(Version version) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = new JsonFactory().createGenerator((Writer)writer);
            generator.useDefaultPrettyPrinter();
            VersionParser.toJson(version, generator);
            generator.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to write json for: %s", new Object[]{version});
        }
    }

    static Version fromJson(JsonNode node) {
        Preconditions.checkArgument((boolean)node.isObject(), (String)"Cannot parse table version from a non-object: %s", (Object)node);
        int versionId = JsonUtil.getInt((String)VERSION_ID, (JsonNode)node);
        Integer parentId = null;
        if (node.has(PARENT_VERSION_ID)) {
            parentId = JsonUtil.getInt((String)PARENT_VERSION_ID, (JsonNode)node);
        }
        long timestamp = JsonUtil.getLong((String)TIMESTAMP_MS, (JsonNode)node);
        VersionSummary summary = null;
        Object operation = null;
        if (node.has(SUMMARY)) {
            JsonNode summaryNode = node.get(SUMMARY);
            Preconditions.checkArgument((summaryNode != null && !summaryNode.isNull() && summaryNode.isObject() ? 1 : 0) != 0, (String)"Cannot parse summary from non-object value: %s", (Object)summaryNode);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            Iterator fields = summaryNode.fieldNames();
            while (fields.hasNext()) {
                String field = (String)fields.next();
                if (field.equals(OPERATION)) {
                    builder.put((Object)OPERATION, (Object)JsonUtil.getString((String)field, (JsonNode)summaryNode));
                    continue;
                }
                if (field.equals("genie_id")) {
                    builder.put((Object)"genie_id", (Object)JsonUtil.getString((String)field, (JsonNode)summaryNode));
                    continue;
                }
                if (field.equals("engine_version")) {
                    builder.put((Object)"engine_version", (Object)JsonUtil.getString((String)field, (JsonNode)summaryNode));
                    continue;
                }
                builder.put((Object)field, (Object)JsonUtil.getString((String)field, (JsonNode)summaryNode));
            }
            summary = new VersionSummary((Map<String, String>)builder.build());
        }
        if (!node.has(VIEW_DEFINITION)) {
            throw new RuntimeIOException("Failed to read view metadata from json: %s", new Object[]{node});
        }
        JsonNode viewMetadataNode = node.get(VIEW_DEFINITION);
        ViewDefinition viewMetadata = ViewDefinitionParser.fromJson(viewMetadataNode);
        return new BaseVersion(versionId, parentId, timestamp, summary, viewMetadata);
    }

    public static Version fromJson(String json) {
        try {
            return VersionParser.fromJson((JsonNode)JsonUtil.mapper().readValue(json, JsonNode.class));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to read version from json: %s", new Object[]{json});
        }
    }
}

