/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.view.HadoopViews;
import org.apache.iceberg.view.ViewDefinition;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.io.TempDir;

public class TestHadoopViewBase {
    static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"c1", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)4, (String)"c2", (Type)Types.IntegerType.get())});
    static final String DEF = "select * from base";
    static final HadoopViews VIEWS = new HadoopViews(new Configuration());
    static File tableDir = null;
    static String tableLocation = null;
    static File metadataDir = null;
    static File versionHintFile = null;
    static ViewDefinition viewDefinition = null;

    @BeforeAll
    public static void setupTable(@TempDir File dir) {
        tableDir = dir;
        tableLocation = tableDir.toURI().toString();
        metadataDir = new File(tableDir, "metadata");
        versionHintFile = new File(metadataDir, "version-hint.text");
    }

    File version(int i) {
        return new File(metadataDir, "v" + i + ".json");
    }

    int readVersionHint() throws IOException {
        return Integer.parseInt(Files.readFirstLine((File)versionHintFile, (Charset)Charsets.UTF_8));
    }
}

