/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.iceberg.view.BaseViewDefinition;
import org.apache.iceberg.view.TestHadoopViewBase;
import org.apache.iceberg.view.View;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.Alphanumeric.class)
public class TestHadoopViews
extends TestHadoopViewBase {
    @Override
    int readVersionHint() throws IOException {
        return Integer.parseInt(Files.readFirstLine((File)versionHintFile, (Charset)Charsets.UTF_8));
    }

    @Test
    public void testView1() throws Exception {
        viewDefinition = new BaseViewDefinition("select * from base", SCHEMA, "", new ArrayList());
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("engine_version", "test-engine");
        VIEWS.create(tableLocation, viewDefinition, properties);
        Assertions.assertThat((File)tableDir).exists();
        Assertions.assertThat((File)metadataDir).exists().isDirectory();
        Assertions.assertThat((File)this.version(1)).exists().isFile();
        Assertions.assertThat((File)this.version(2)).doesNotExist();
        Assertions.assertThat((File)versionHintFile).exists();
        Assertions.assertThat((int)this.readVersionHint()).isEqualTo(1);
    }

    @Test
    public void testView2() throws Exception {
        VIEWS.replace(tableLocation, viewDefinition, new HashMap());
        Assertions.assertThat((File)tableDir).exists();
        Assertions.assertThat((File)metadataDir).exists().isDirectory();
        Assertions.assertThat((File)this.version(1)).exists().isFile();
        Assertions.assertThat((File)this.version(2)).exists().isFile();
        Assertions.assertThat((File)this.version(3)).doesNotExist();
        Assertions.assertThat((File)versionHintFile).exists();
        Assertions.assertThat((int)this.readVersionHint()).isEqualTo(2);
    }

    @Test
    public void testView3() throws Exception {
        VIEWS.replace(tableLocation, viewDefinition, new HashMap());
        Assertions.assertThat((File)tableDir).exists();
        Assertions.assertThat((File)metadataDir).exists().isDirectory();
        Assertions.assertThat((File)this.version(1)).exists().isFile();
        Assertions.assertThat((File)this.version(2)).exists().isFile();
        Assertions.assertThat((File)this.version(3)).exists().isFile();
        Assertions.assertThat((File)this.version(4)).doesNotExist();
        Assertions.assertThat((File)versionHintFile).exists();
        Assertions.assertThat((int)this.readVersionHint()).isEqualTo(3);
    }

    @Test
    public void testView4() throws Exception {
        View view = VIEWS.load(tableLocation);
        view.updateProperties().set("version.history.num-entries", "3").commit();
        view.updateProperties().set("comment", "A dummy table comment").commit();
        VIEWS.replace(tableLocation, viewDefinition, new HashMap());
        Assertions.assertThat((File)tableDir).exists();
        Assertions.assertThat((File)metadataDir).exists().isDirectory();
        Assertions.assertThat((File)this.version(1)).exists().isFile();
        Assertions.assertThat((File)this.version(2)).exists().isFile();
        Assertions.assertThat((File)this.version(3)).exists().isFile();
        Assertions.assertThat((File)this.version(4)).exists().isFile();
        Assertions.assertThat((File)this.version(5)).exists().isFile();
        Assertions.assertThat((File)this.version(6)).exists().isFile();
        Assertions.assertThat((File)this.version(7)).doesNotExist();
        Assertions.assertThat((File)versionHintFile).exists();
        Assertions.assertThat((int)this.readVersionHint()).isEqualTo(6);
    }

    @Test
    public void testView5() {
        VIEWS.drop(tableLocation);
        Assertions.assertThat((File)metadataDir).doesNotExist();
        Assertions.assertThat((File)tableDir).doesNotExist();
    }
}

