/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.apache.iceberg.view.HistoryEntry;

public class VersionLogEntry
implements HistoryEntry {
    private final long timestampMillis;
    private final int versionId;

    VersionLogEntry(long timestampMillis, int versionId) {
        this.timestampMillis = timestampMillis;
        this.versionId = versionId;
    }

    @Override
    public long timestampMillis() {
        return this.timestampMillis;
    }

    @Override
    public int versionId() {
        return this.versionId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        VersionLogEntry that = (VersionLogEntry)other;
        return this.timestampMillis == that.timestampMillis && this.versionId == that.versionId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.timestampMillis, this.versionId});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("timestampMillis", this.timestampMillis).add("versionId", this.versionId).toString();
    }
}

