/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.view.BaseView;
import org.apache.iceberg.view.TestViewBase;
import org.apache.iceberg.view.TestViews;
import org.apache.iceberg.view.Version;
import org.apache.iceberg.view.ViewDefinition;
import org.apache.iceberg.view.ViewVersionMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestViewCreateReplace
extends TestViewBase {
    @Test
    public void testViewCreateReplace() {
        ViewVersionMetadata viewVersionMetadata = TestViews.loadViewVersionMetadata(this.metadataDir, "test");
        ViewDefinition oldViewMetadata = viewVersionMetadata.definition();
        ViewDefinition viewMetadata = ViewDefinition.of((String)"select sum(1) from base_tab", (Schema)oldViewMetadata.schema(), (String)"", new ArrayList());
        TestViews.replace(this.metadataDir, "test", viewMetadata, new HashMap<String, String>());
        viewVersionMetadata = TestViews.loadViewVersionMetadata(this.metadataDir, "test");
        oldViewMetadata = viewVersionMetadata.definition();
        Assertions.assertEquals((Object)oldViewMetadata.sql(), (Object)"select sum(1) from base_tab");
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"intData", (Type)Types.IntegerType.get())});
        viewMetadata = ViewDefinition.of((String)"select id, intData from base_tab", (Schema)newSchema, (String)"new catalog", new ArrayList());
        TestViews.replace(this.metadataDir, "test", viewMetadata, new HashMap<String, String>());
        viewVersionMetadata = TestViews.loadViewVersionMetadata(this.metadataDir, "test");
        oldViewMetadata = viewVersionMetadata.definition();
        Assertions.assertEquals((Object)oldViewMetadata.schema().toString(), (Object)newSchema.toString());
        Assertions.assertEquals((Object)oldViewMetadata.sessionCatalog(), (Object)"new catalog");
        Assertions.assertEquals(viewVersionMetadata.currentVersion().summary().properties().get("engine_version"), (Object)"TestEngine");
        BaseView view = TestViews.load(null, "test");
        view.updateProperties().set("comment", "A dummy table comment").commit();
        viewVersionMetadata = TestViews.loadViewVersionMetadata(this.metadataDir, "test");
        Assertions.assertEquals(viewVersionMetadata.properties().get("comment"), (Object)"A dummy table comment");
        Assertions.assertEquals((int)viewVersionMetadata.currentVersionId(), (int)3);
        Assertions.assertEquals((int)viewVersionMetadata.versions().size(), (int)3);
        Assertions.assertEquals((long)((Version)viewVersionMetadata.versions().get(2)).parentId().longValue(), (long)2L);
    }
}

