/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.JsonUtil;
import org.apache.iceberg.view.ViewDefinition;
import org.apache.iceberg.view.ViewDefinitionParser;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

public class TestViewDefinitionParser {
    @Test
    public void testBasic() throws IOException {
        this.checkViewDefinitionSerialization("SELECT 'foo' foo", new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"foo", (Type)Types.StringType.get())}), "cat", Arrays.asList("part1", "part2"));
    }

    @Test
    public void testEmptyCatalogNamespace() throws IOException {
        this.checkViewDefinitionSerialization("SELECT 1 intcol, 'str' strcol", new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"intcol", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"strcol", (Type)Types.StringType.get())}), "", Collections.emptyList());
    }

    private void checkViewDefinitionSerialization(String sql, Schema schema, String sessionCatalog, List<String> sessionNamespace) throws IOException {
        ViewDefinition expected = ViewDefinition.of((String)sql, (Schema)schema, (String)sessionCatalog, sessionNamespace);
        StringWriter jsonWriter = new StringWriter();
        JsonGenerator generator = new JsonFactory().createGenerator((Writer)jsonWriter);
        ViewDefinitionParser.toJson((ViewDefinition)expected, (JsonGenerator)generator);
        generator.flush();
        ViewDefinition actual = ViewDefinitionParser.fromJson((JsonNode)((JsonNode)JsonUtil.mapper().readValue(((Object)jsonWriter).toString(), JsonNode.class)));
        AssertionsForClassTypes.assertThat((Object)actual).isEqualTo((Object)expected);
    }
}

