/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.common.base.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.view.ViewOperations;
import org.apache.iceberg.view.ViewVersionMetadata;
import org.apache.iceberg.view.ViewVersionMetadataParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMetastoreViewOperations
implements ViewOperations {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMetastoreViewOperations.class);
    public static final String METADATA_LOCATION_PROP = "metadata_location";
    public static final String PREVIOUS_METADATA_LOCATION_PROP = "previous_metadata_location";
    public static final String METADATA_FOLDER_NAME = "metadata";
    private ViewVersionMetadata currentMetadata = null;
    private String currentMetadataLocation = null;
    private boolean shouldRefresh = true;
    private int version = -1;

    @Override
    public ViewVersionMetadata current() {
        if (this.shouldRefresh) {
            return this.refresh();
        }
        return this.currentMetadata;
    }

    public String currentMetadataLocation() {
        return this.currentMetadataLocation;
    }

    public int currentVersion() {
        return this.version;
    }

    protected void requestRefresh() {
        this.shouldRefresh = true;
    }

    protected String writeNewMetadata(ViewVersionMetadata metadata, int version) {
        String newViewMetadataFilePath = this.newViewMetadataFilePath(metadata, version);
        OutputFile newMetadataLocation = this.io().newOutputFile(newViewMetadataFilePath);
        ViewVersionMetadataParser.overwrite(metadata, newMetadataLocation);
        return newViewMetadataFilePath;
    }

    protected void refreshFromMetadataLocation(String newLocation, Predicate<Exception> shouldRetry, int numRetries, Function<String, ViewVersionMetadata> metadataLoader) {
        if (!Objects.equal((Object)this.currentMetadataLocation, (Object)newLocation)) {
            LOG.info("Refreshing table metadata from new version: {}", (Object)newLocation);
            AtomicReference newMetadata = new AtomicReference();
            Tasks.foreach((Object[])new String[]{newLocation}).retry(numRetries).exponentialBackoff(100L, 5000L, 600000L, 4.0).throwFailureWhenFinished().shouldRetryTest(shouldRetry).run(metadataLocation -> newMetadata.set((ViewVersionMetadata)metadataLoader.apply((String)metadataLocation)));
            this.currentMetadata = (ViewVersionMetadata)newMetadata.get();
            this.currentMetadataLocation = newLocation;
            this.version = BaseMetastoreViewOperations.parseVersion(newLocation);
        }
        this.shouldRefresh = false;
    }

    private String metadataFileLocation(ViewVersionMetadata metadata, String filename) {
        return String.format("%s/%s/%s", metadata.location(), METADATA_FOLDER_NAME, filename);
    }

    private String newViewMetadataFilePath(ViewVersionMetadata meta, int newVersion) {
        return this.metadataFileLocation(meta, String.format("%05d-%s%s", newVersion, UUID.randomUUID(), ".metadata.json"));
    }

    private static int parseVersion(String metadataLocation) {
        int versionStart = metadataLocation.lastIndexOf(47) + 1;
        int versionEnd = metadataLocation.indexOf(45, versionStart);
        try {
            return Integer.parseInt(metadataLocation.substring(versionStart, versionEnd));
        }
        catch (NumberFormatException e) {
            LOG.warn("Unable to parse version from metadata location: {}", (Object)metadataLocation);
            return -1;
        }
    }
}

