/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.view.BaseVersion;
import org.apache.iceberg.view.HistoryEntry;
import org.apache.iceberg.view.Version;
import org.apache.iceberg.view.VersionLogEntry;
import org.apache.iceberg.view.ViewDefinition;

public class ViewVersionMetadata {
    static final int VIEW_FORMAT_VERSION = 1;
    private final String location;
    private final Map<String, String> properties;
    private final int currentVersionId;
    private List<Version> versions;
    private final Map<Integer, Version> versionsById;
    private List<HistoryEntry> versionLog;
    private final ViewDefinition definition;

    public static ViewVersionMetadata newViewVersionMetadata(BaseVersion version, String location, ViewDefinition definition, Map<String, String> properties) {
        return new ViewVersionMetadata(version, location, definition, properties, (List<Version>)ImmutableList.of(), (List<HistoryEntry>)ImmutableList.of());
    }

    public static ViewVersionMetadata newViewVersionMetadata(BaseVersion version, String location, ViewDefinition definition, Map<String, String> properties, List<Version> versions, List<HistoryEntry> history) {
        return new ViewVersionMetadata(version, location, definition, properties, versions, history);
    }

    public static ViewVersionMetadata newViewVersionMetadata(BaseVersion version, String location, ViewDefinition definition, ViewVersionMetadata viewVersionMetadata, Map<String, String> properties) {
        return new ViewVersionMetadata(version, location, definition, properties, viewVersionMetadata.versions(), viewVersionMetadata.history());
    }

    public ViewVersionMetadata(String location, ViewDefinition definition, Map<String, String> properties, int currentVersionId, List<Version> versions, List<HistoryEntry> versionLog) {
        this.location = location;
        this.definition = definition;
        this.properties = properties;
        Preconditions.checkState((versions.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkState((versionLog.size() > 0 ? 1 : 0) != 0);
        this.currentVersionId = currentVersionId;
        this.versions = versions;
        this.versionLog = versionLog;
        this.versionsById = ViewVersionMetadata.indexVersions(versions);
        HistoryEntry last = null;
        for (HistoryEntry logEntry : versionLog) {
            if (last != null) {
                Preconditions.checkArgument((logEntry.timestampMillis() - last.timestampMillis() >= 0L ? 1 : 0) != 0, (Object)"[BUG] Expected sorted version log entries.");
            }
            last = logEntry;
        }
    }

    ViewVersionMetadata(BaseVersion version, String location, ViewDefinition definition, Map<String, String> properties, List<Version> versions, List<HistoryEntry> versionLog) {
        this.location = location;
        this.definition = definition;
        this.properties = properties;
        this.currentVersionId = version.versionId();
        ArrayList<Version> allVersions = new ArrayList<Version>(versions);
        allVersions.add(version);
        ArrayList<HistoryEntry> allHistory = new ArrayList<HistoryEntry>(versionLog);
        allHistory.add(new VersionLogEntry(version.timestampMillis(), this.currentVersionId));
        int numVersionsToKeep = this.propertyAsInt("version.history.num-entries", 10);
        if (allVersions.size() > numVersionsToKeep) {
            this.versions = ImmutableList.builder().addAll(allVersions.subList(allVersions.size() - numVersionsToKeep, allVersions.size())).build();
            this.versionLog = ImmutableList.builder().addAll(allHistory.subList(allHistory.size() - numVersionsToKeep, allHistory.size())).build();
        } else {
            this.versions = ImmutableList.builder().addAll(allVersions).build();
            this.versionLog = ImmutableList.builder().addAll(allHistory).build();
        }
        this.versionsById = ViewVersionMetadata.indexVersions(this.versions);
        HistoryEntry last = null;
        for (HistoryEntry logEntry : this.versionLog) {
            if (last != null) {
                Preconditions.checkArgument((logEntry.timestampMillis() - last.timestampMillis() >= 0L ? 1 : 0) != 0, (Object)"[BUG] Expected sorted version log entries.");
            }
            last = logEntry;
        }
    }

    public String location() {
        return this.location;
    }

    public ViewDefinition definition() {
        return this.definition;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public String property(String property, String defaultValue) {
        return this.properties.getOrDefault(property, defaultValue);
    }

    public int propertyAsInt(String property, int defaultValue) {
        String value = this.properties.get(property);
        if (value != null) {
            return Integer.parseInt(this.properties.get(property));
        }
        return defaultValue;
    }

    public Version version(int versionId) {
        return this.versionsById.get(versionId);
    }

    public Version currentVersion() {
        return this.versionsById.get(this.currentVersionId);
    }

    public int currentVersionId() {
        return this.currentVersionId;
    }

    public List<Version> versions() {
        return this.versions;
    }

    public List<HistoryEntry> history() {
        return this.versionLog;
    }

    private static Map<Integer, Version> indexVersions(List<Version> versions) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Version version : versions) {
            builder.put((Object)version.versionId(), (Object)version);
        }
        return builder.build();
    }

    public ViewVersionMetadata replaceProperties(Map<String, String> newProperties) {
        ValidationException.check((newProperties != null ? 1 : 0) != 0, (String)"Cannot set properties to null", (Object[])new Object[0]);
        return new ViewVersionMetadata(this.location, this.definition, newProperties, this.currentVersionId, this.versions, this.versionLog);
    }
}

