/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.nessie.NessieCatalog;
import org.apache.iceberg.nessie.NessieViewCatalog;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewDefinition;
import org.apache.iceberg.view.Views;
import org.projectnessie.error.NessieNotFoundException;

public class NessieExtCatalog
extends BaseMetastoreCatalog
implements Views {
    private NessieViewCatalog viewCatalog;
    private NessieCatalog tableCatalog;
    private Configuration configuration;

    public void initialize(String name, Map<String, String> properties) {
        this.tableCatalog = new NessieCatalog();
        this.tableCatalog.setConf(this.configuration);
        this.tableCatalog.initialize(name, properties);
        this.viewCatalog = new NessieViewCatalog(this.configuration);
        this.viewCatalog.initialize("nessie_view_catalog", properties);
    }

    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        return this.tableCatalog.newTableOps(tableIdentifier);
    }

    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        return this.tableCatalog.defaultWarehouseLocation(tableIdentifier);
    }

    public List<TableIdentifier> listTables(Namespace namespace) {
        return this.tableCatalog.listTables(namespace);
    }

    public boolean dropTable(TableIdentifier tableIdentifier, boolean purge) {
        return this.tableCatalog.dropTable(tableIdentifier, purge);
    }

    public void renameTable(TableIdentifier from, TableIdentifier to) {
        this.tableCatalog.renameTable(from, to);
    }

    @Override
    public void create(String viewIdentifier, ViewDefinition viewDefinition, Map<String, String> properties) {
        this.viewCatalog.create(viewIdentifier, viewDefinition, properties);
    }

    @Override
    public void replace(String viewIdentifier, ViewDefinition viewDefinition, Map<String, String> properties) {
        this.viewCatalog.replace(viewIdentifier, viewDefinition, properties);
    }

    @Override
    public View load(String viewIdentifier) {
        return this.viewCatalog.load(viewIdentifier);
    }

    @Override
    public ViewDefinition loadDefinition(String viewIdentifier) {
        return this.viewCatalog.loadDefinition(viewIdentifier);
    }

    @Override
    public void drop(String viewIdentifier) {
        this.viewCatalog.drop(viewIdentifier);
    }

    public void setConf(Configuration conf) {
        this.configuration = conf;
    }

    public void refresh() throws NessieNotFoundException {
        this.viewCatalog.refresh();
    }

    public void close() throws IOException {
        this.tableCatalog.close();
        this.viewCatalog.close();
    }

    @VisibleForTesting
    public NessieViewCatalog getViewCatalog() {
        return this.viewCatalog;
    }
}

