/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.NessieUtil;
import org.apache.iceberg.nessie.UpdateableReference;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.view.BaseMetastoreViewOperations;
import org.apache.iceberg.view.BaseVersion;
import org.apache.iceberg.view.HistoryEntry;
import org.apache.iceberg.view.Version;
import org.apache.iceberg.view.ViewUtils;
import org.apache.iceberg.view.ViewVersionMetadata;
import org.apache.iceberg.view.ViewVersionMetadataParser;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableIcebergView;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieViewOperations
extends BaseMetastoreViewOperations {
    private static final Logger LOG = LoggerFactory.getLogger(NessieViewOperations.class);
    private final NessieApiV1 api;
    private final ContentKey key;
    private final UpdateableReference reference;
    private IcebergView icebergView;
    private final FileIO fileIO;
    private final Map<String, String> catalogOptions;

    NessieViewOperations(ContentKey key, UpdateableReference reference, NessieApiV1 api, FileIO fileIO, Map<String, String> catalogOptions) {
        this.key = key;
        this.reference = reference;
        this.api = api;
        this.fileIO = fileIO;
        this.catalogOptions = catalogOptions;
    }

    @Override
    public ViewVersionMetadata refresh() {
        String metadataLocation;
        block7: {
            try {
                this.reference.refresh(this.api);
            }
            catch (NessieNotFoundException e) {
                throw new RuntimeException("Failed to refresh as ref is no longer valid.", e);
            }
            metadataLocation = null;
            try {
                Content content = (Content)((GetContentBuilder)this.api.getContent().key(this.key).reference(this.reference.getReference())).get().get(this.key);
                LOG.debug("Content '{}' at '{}': {}", new Object[]{this.key, this.reference.getReference(), content});
                if (content == null) {
                    if (this.currentMetadataLocation() != null) {
                        throw new NoSuchTableException("No such view %s in %s", new Object[]{this.key, this.reference.getReference()});
                    }
                } else {
                    this.icebergView = (IcebergView)content.unwrap(IcebergView.class).orElseThrow(() -> new IllegalStateException("Cannot refresh iceberg view: " + String.format("Nessie points to a non-Iceberg object for path: %s.", this.key)));
                    metadataLocation = this.icebergView.getMetadataLocation();
                }
            }
            catch (NessieNotFoundException ex) {
                if (this.currentMetadataLocation() == null) break block7;
                throw new NoSuchTableException((Throwable)ex, "No such view %s", new Object[]{this.key});
            }
        }
        this.refreshFromMetadataLocation(metadataLocation, exc -> !exc.getClass().getCanonicalName().contains("Unrecoverable"), 2, this::loadViewMetadata);
        return this.current();
    }

    private ViewVersionMetadata loadViewMetadata(String metadataLocation) {
        ViewVersionMetadata metadata = ViewVersionMetadataParser.read(this.io().newInputFile(metadataLocation));
        Optional<Version> viewVersion = metadata.versions().stream().filter(v -> v.versionId() == this.icebergView.getVersionId()).findFirst();
        if (viewVersion.isPresent()) {
            Version v2 = viewVersion.get();
            BaseVersion baseVersion = new BaseVersion(v2.versionId(), v2.parentId(), v2.timestampMillis(), v2.summary(), v2.viewDefinition());
            List<Version> versions = this.getVersionsUntil(metadata, this.icebergView.getVersionId());
            List<HistoryEntry> history = this.getHistoryEntriesUntil(metadata, this.icebergView.getVersionId());
            metadata = ViewVersionMetadata.newViewVersionMetadata(baseVersion, metadata.location(), v2.viewDefinition(), metadata.properties(), versions, history);
        }
        return metadata;
    }

    private List<HistoryEntry> getHistoryEntriesUntil(ViewVersionMetadata metadata, int versionId) {
        ArrayList<HistoryEntry> history = new ArrayList<HistoryEntry>();
        for (HistoryEntry entry : metadata.history()) {
            if (entry.versionId() == versionId) break;
            history.add(entry);
        }
        return history;
    }

    private List<Version> getVersionsUntil(ViewVersionMetadata metadata, int versionId) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (Version version : metadata.versions()) {
            if (version.versionId() == versionId) break;
            versions.add(version);
        }
        return versions;
    }

    private IcebergView view(TableIdentifier viewIdentifier) {
        try {
            ContentKey key = NessieUtil.toKey((TableIdentifier)viewIdentifier);
            Content view = (Content)((GetContentBuilder)this.api.getContent().key(key).reference(this.reference.getReference())).get().get(key);
            return view != null ? (IcebergView)view.unwrap(IcebergView.class).orElse(null) : null;
        }
        catch (NessieNotFoundException e) {
            return null;
        }
    }

    @Override
    public void drop(String viewIdentifier) {
        this.reference.checkMutable();
        IcebergView existingView = this.view(ViewUtils.toCatalogTableIdentifier(viewIdentifier));
        if (existingView == null) {
            return;
        }
        CommitMultipleOperationsBuilder commitBuilderBase = this.api.commitMultipleOperations().commitMeta(NessieUtil.buildCommitMetadata((String)String.format("Iceberg delete view %s", viewIdentifier), this.catalogOptions)).operation((Operation)Operation.Delete.of((ContentKey)NessieUtil.toKey((TableIdentifier)ViewUtils.toCatalogTableIdentifier(viewIdentifier))));
        try {
            Tasks.foreach((Object[])new CommitMultipleOperationsBuilder[]{commitBuilderBase}).retry(5).stopRetryOn(new Class[]{NessieNotFoundException.class}).throwFailureWhenFinished().onFailure((o, exception) -> this.refresh()).run(commitBuilder -> {
                Branch branch = ((CommitMultipleOperationsBuilder)commitBuilder.branch(this.reference.getAsBranch())).commit();
                this.reference.updateReference((Reference)branch);
            }, BaseNessieClientServerException.class);
        }
        catch (NessieConflictException e) {
            LOG.error("Cannot drop view: failed after retry (update ref and retry)", (Throwable)e);
        }
        catch (NessieNotFoundException e) {
            LOG.error("Cannot drop view: ref is no longer valid.", (Throwable)e);
        }
        catch (BaseNessieClientServerException e) {
            LOG.error("Cannot drop view: unknown error", (Throwable)e);
        }
    }

    @Override
    public void commit(ViewVersionMetadata base, ViewVersionMetadata metadata, Map<String, String> properties) {
        this.reference.checkMutable();
        String newMetadataLocation = this.writeNewMetadata(metadata, this.currentVersion() + 1);
        boolean delete = true;
        try {
            ImmutableIcebergView.Builder viewBuilder = ImmutableIcebergView.builder();
            if (this.icebergView != null) {
                viewBuilder.id(this.icebergView.getId());
            }
            ImmutableIcebergView newView = viewBuilder.metadataLocation(newMetadataLocation).versionId(metadata.currentVersionId()).schemaId(metadata.definition().schema().schemaId()).dialect("TODO: needs to be defined in Iceberg ViewDefinition").sqlText(metadata.definition().sql()).build();
            LOG.debug("Committing '{}' against '{}': {}", new Object[]{this.key, this.reference.getReference(), newView});
            ImmutableCommitMeta.Builder builder = ImmutableCommitMeta.builder();
            builder.message(this.buildCommitMsg(base, metadata) + " " + this.key.getName());
            Branch branch = ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().operation((Operation)Operation.Put.of((ContentKey)this.key, (Content)newView, (Content)this.icebergView)).commitMeta((CommitMeta)NessieUtil.catalogOptions((ImmutableCommitMeta.Builder)builder, this.catalogOptions).build()).branch(this.reference.getAsBranch())).commit();
            this.reference.updateReference((Reference)branch);
            delete = false;
        }
        catch (NessieConflictException ex) {
            throw new CommitFailedException((Throwable)ex, "Commit failed: Reference hash is out of date. Update the reference %s and try again", new Object[]{this.reference.getName()});
        }
        catch (HttpClientException ex) {
            delete = false;
            throw new CommitStateUnknownException((Throwable)ex);
        }
        catch (NessieNotFoundException ex) {
            throw new RuntimeException(String.format("Commit failed: Reference %s no longer exist", this.reference.getName()), ex);
        }
        finally {
            if (delete) {
                this.io().deleteFile(newMetadataLocation);
            }
        }
    }

    private String buildCommitMsg(ViewVersionMetadata base, ViewVersionMetadata metadata) {
        if (base != null && metadata.currentVersionId() != base.currentVersionId()) {
            return "Iceberg schema change against view ";
        }
        return "Iceberg commit against view %s";
    }

    @Override
    public FileIO io() {
        return this.fileIO;
    }
}

