/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.view.BaseVersion;
import org.apache.iceberg.view.BaseViewDefinition;
import org.apache.iceberg.view.CommonViewConstants;
import org.apache.iceberg.view.EngineProperties;
import org.apache.iceberg.view.VersionSummary;
import org.apache.iceberg.view.ViewDefinition;
import org.apache.iceberg.view.ViewOperations;
import org.apache.iceberg.view.ViewVersionMetadata;

public class ViewUtils {
    public static Map<String, String> getSummaryProperties(String operation, Map<String, String> properties, Map<String, String> prevProperties) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (CommonViewConstants.ViewVersionSummaryConstants key : CommonViewConstants.ViewVersionSummaryConstants.values()) {
            String val = properties.get(key.name());
            if (val != null) {
                props.put(String.valueOf((Object)key), val);
                continue;
            }
            if (prevProperties == null || (val = prevProperties.get(key.name())) == null) continue;
            props.put(String.valueOf((Object)key), val);
        }
        props.put("operation", operation);
        return props;
    }

    public static Map<String, String> getMetacatProperties(Map<String, String> properties) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (EngineProperties key : EngineProperties.values()) {
            String val = properties.get(key.name());
            if (val == null) continue;
            props.put(String.valueOf((Object)key), val);
        }
        return props;
    }

    public static Map<String, String> getViewVersionMetadataProperties(Map<String, String> properties, Map<String, String> prevProperties, Map<String, String> summaryProperties, Map<String, String> metacatProperties) {
        HashMap<String, String> props = new HashMap<String, String>(prevProperties);
        props.putAll(properties);
        props.keySet().removeAll(summaryProperties.keySet());
        props.keySet().removeAll(metacatProperties.keySet());
        return props;
    }

    public static void doCommit(String operation, Map<String, String> properties, int versionId, int parentId, ViewDefinition definition, String location, ViewOperations ops, ViewVersionMetadata prevViewVersionMetadata) {
        Map<String, String> prevViewVersionMetadataProps;
        HashMap<String, String> prevSummaryProps;
        if (prevViewVersionMetadata != null) {
            prevSummaryProps = prevViewVersionMetadata.currentVersion().summary().properties();
            prevViewVersionMetadataProps = prevViewVersionMetadata.properties();
        } else {
            prevSummaryProps = new HashMap();
            prevViewVersionMetadataProps = new HashMap<String, String>();
        }
        Map<String, String> summaryProps = ViewUtils.getSummaryProperties(operation, properties, prevSummaryProps);
        VersionSummary summary = new VersionSummary(summaryProps);
        Map<String, String> metacatProps = ViewUtils.getMetacatProperties(properties);
        Map<String, String> viewVersionMetadataProperties = ViewUtils.getViewVersionMetadataProperties(properties, prevViewVersionMetadataProps, summaryProps, metacatProps);
        ViewDefinition definitionWithComments = definition;
        if (prevViewVersionMetadata != null) {
            definitionWithComments = ViewUtils.retainColumnComments(definition, prevViewVersionMetadata.definition());
        }
        BaseVersion version = new BaseVersion(versionId, parentId, System.currentTimeMillis(), summary, definitionWithComments);
        ViewVersionMetadata viewVersionMetadata = prevViewVersionMetadata == null ? ViewVersionMetadata.newViewVersionMetadata(version, location, definitionWithComments, viewVersionMetadataProperties) : ViewVersionMetadata.newViewVersionMetadata(version, location, definitionWithComments, prevViewVersionMetadata, viewVersionMetadataProperties);
        ops.commit(prevViewVersionMetadata, viewVersionMetadata, metacatProps);
    }

    public static ViewDefinition retainColumnComments(ViewDefinition newDef, ViewDefinition oldDef) {
        ArrayList<Types.NestedField> newCols = new ArrayList<Types.NestedField>();
        for (Types.NestedField col : newDef.schema().columns()) {
            if (col.doc() == null) {
                Types.NestedField oldCol = oldDef.schema().caseInsensitiveFindField(col.name());
                if (oldCol != null) {
                    Types.NestedField newCol = Types.NestedField.of((int)col.fieldId(), (boolean)col.isOptional(), (String)col.name(), (Type)col.type(), (String)oldCol.doc());
                    newCols.add(newCol);
                    continue;
                }
                newCols.add(col);
                continue;
            }
            newCols.add(col);
        }
        Schema enhancedSchema = new Schema(newCols);
        return new BaseViewDefinition(newDef.sql(), enhancedSchema, newDef.sessionCatalog(), newDef.sessionNamespace());
    }

    public static void validateTableIdentifier(TableIdentifier viewIdentifier) {
        Preconditions.checkArgument((boolean)viewIdentifier.hasNamespace(), (Object)"viewIdentifier should have namespace");
        Preconditions.checkArgument((viewIdentifier.namespace().levels().length == 2 ? 1 : 0) != 0, (Object)"namespace should have catalog.schema");
    }

    public static TableIdentifier toCatalogTableIdentifier(String tableIdentifier) {
        ArrayList<String> namespace = new ArrayList<String>();
        Iterable parts = Splitter.on((String)".").split((CharSequence)tableIdentifier);
        String lastPart = "";
        for (String part : parts) {
            if (!lastPart.isEmpty()) {
                namespace.add(lastPart);
            }
            lastPart = part;
        }
        Preconditions.checkState((namespace.size() == 2 ? 1 : 0) != 0, (Object)"Catalog and schema are expected in the namespace.");
        return TableIdentifier.of((Namespace)Namespace.of((String[])namespace.toArray(new String[namespace.size()])), (String)lastPart);
    }
}

