/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.view.ViewOperations;
import org.apache.iceberg.view.ViewVersionMetadata;
import org.apache.iceberg.view.ViewVersionMetadataParser;

public class HadoopViewOperations
implements ViewOperations {
    private final Configuration conf;
    private final Path location;
    private ViewVersionMetadata currentMetadata = null;
    private Integer version = null;
    private boolean shouldRefresh = true;
    private HadoopFileIO defaultFileIo = null;

    protected HadoopViewOperations(Path location, Configuration conf) {
        this.conf = conf;
        this.location = location;
    }

    @Override
    public ViewVersionMetadata current() {
        if (this.shouldRefresh) {
            return this.refresh();
        }
        return this.currentMetadata;
    }

    private Path metadataFile(int version) {
        return this.metadataPath("v" + version + ".json");
    }

    @Override
    public ViewVersionMetadata refresh() {
        int ver = this.version != null ? this.version.intValue() : this.readVersionHint();
        Path metadataFile = this.metadataFile(ver);
        FileSystem fs = HadoopViewOperations.getFS(metadataFile, this.conf);
        try {
            if (this.version == null && !fs.exists(metadataFile)) {
                if (ver == 0) {
                    return null;
                }
                throw new ValidationException("Metadata file is missing: %s", new Object[]{metadataFile});
            }
            while (fs.exists(this.metadataFile(ver + 1))) {
                metadataFile = this.metadataFile(++ver);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to get file system for path: %s", new Object[]{metadataFile});
        }
        this.version = ver;
        this.currentMetadata = ViewVersionMetadataParser.read(this.io().newInputFile(metadataFile.toString()));
        this.shouldRefresh = false;
        return this.currentMetadata;
    }

    @Override
    public FileIO io() {
        if (this.defaultFileIo == null) {
            this.defaultFileIo = new HadoopFileIO(this.conf);
        }
        return this.defaultFileIo;
    }

    @Override
    public void commit(ViewVersionMetadata base, ViewVersionMetadata metadata, Map<String, String> properties) {
        if (base != this.current()) {
            throw new CommitFailedException("Cannot commit changes based on stale table metadata", new Object[0]);
        }
        if (base == metadata) {
            return;
        }
        Preconditions.checkArgument((base == null || base.location().equals(metadata.location()) ? 1 : 0) != 0, (Object)"Hadoop path-based tables cannot be relocated");
        Preconditions.checkArgument((!metadata.properties().containsKey("write.metadata.path") ? 1 : 0) != 0, (Object)"Hadoop path-based tables cannot relocate metadata");
        Path tempMetadataFile = this.metadataPath(UUID.randomUUID().toString() + ".json");
        ViewVersionMetadataParser.write(metadata, this.io().newOutputFile(tempMetadataFile.toString()));
        int nextVersion = this.version != null ? this.version + 1 : 1;
        Path finalMetadataFile = this.metadataFile(nextVersion);
        FileSystem fs = HadoopViewOperations.getFS(tempMetadataFile, this.conf);
        try {
            if (fs.exists(finalMetadataFile)) {
                throw new CommitFailedException("Version %d already exists: %s", new Object[]{nextVersion, finalMetadataFile});
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to check if next version exists: %s", new Object[]{finalMetadataFile});
        }
        try {
            if (!fs.rename(tempMetadataFile, finalMetadataFile)) {
                throw new CommitFailedException("Failed to commit changes using rename: %s", new Object[]{finalMetadataFile});
            }
        }
        catch (IOException e) {
            throw new CommitFailedException((Throwable)e, "Failed to commit changes using rename: %s", new Object[]{finalMetadataFile});
        }
        this.writeVersionHint(nextVersion);
        this.shouldRefresh = true;
    }

    @Override
    public void drop(String location) {
        Path path = new Path(location);
        FileSystem fs = HadoopViewOperations.getFS(path, this.conf);
        try {
            fs.delete(path, true);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Failed to delete view metadata.", new Object[0]);
        }
    }

    private Path metadataPath(String filename) {
        return new Path(new Path(this.location, "metadata"), filename);
    }

    private Path versionHintFile() {
        return this.metadataPath("version-hint.text");
    }

    public static FileSystem getFS(Path path, Configuration conf) {
        try {
            return path.getFileSystem(conf);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to get file system for path: %s", new Object[]{path});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readVersionHint() {
        Path versionHintFile = this.versionHintFile();
        try {
            FileSystem fs = HadoopViewOperations.getFS(versionHintFile, this.conf);
            if (!fs.exists(versionHintFile)) {
                return 0;
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(versionHintFile), "UTF-8"));){
                String versionStr = in.readLine();
                if (versionStr != null) {
                    int n = Integer.parseInt(versionStr.replace("\n", ""));
                    return n;
                }
                int n = 0;
                return n;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to get file system for path: %s", new Object[]{versionHintFile});
        }
    }

    private void writeVersionHint(int version) {
        Path versionHintFile = this.versionHintFile();
        FileSystem fs = HadoopViewOperations.getFS(versionHintFile, this.conf);
        try (FSDataOutputStream out = fs.create(versionHintFile, true);){
            out.write(String.valueOf(version).getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to write version hint", new Object[0]);
        }
    }
}

