/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.runner;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.quarkus.runner.InputBuffer;

class TestInputBuffer {
    TestInputBuffer() {
    }

    @Test
    void emptyInput() {
        ArrayList lines = new ArrayList();
        InputBuffer buf = new InputBuffer((Reader)new StringReader(""), lines::add);
        Assertions.assertThat((boolean)buf.io()).isFalse();
        Assertions.assertThat(lines).isEmpty();
        buf.flush();
        Assertions.assertThat(lines).isEmpty();
    }

    @Test
    void scattered() {
        final ArrayBlockingQueue<Integer> characters = new ArrayBlockingQueue<Integer>(250);
        StringReader reader = new StringReader(""){

            @Override
            public int read() {
                return (Integer)characters.poll();
            }

            @Override
            public boolean ready() {
                return characters.size() > 0;
            }
        };
        ArrayList lines = new ArrayList();
        InputBuffer buf = new InputBuffer((Reader)reader, lines::add);
        Assertions.assertThat((boolean)buf.io()).isFalse();
        Assertions.assertThat(lines).isEmpty();
        for (char c : "Hello World".toCharArray()) {
            characters.add(Integer.valueOf(c));
        }
        Assertions.assertThat((boolean)buf.io()).isTrue();
        Assertions.assertThat(lines).isEmpty();
        for (char c : "\nFoo Bar Baz\nMeep".toCharArray()) {
            characters.add(Integer.valueOf(c));
        }
        Assertions.assertThat((boolean)buf.io()).isTrue();
        Assertions.assertThat(lines).containsExactly((Object[])new String[]{"Hello World", "Foo Bar Baz"});
        characters.add(13);
        Assertions.assertThat((boolean)buf.io()).isTrue();
        Assertions.assertThat(lines).containsExactly((Object[])new String[]{"Hello World", "Foo Bar Baz"});
        characters.add(10);
        Assertions.assertThat((boolean)buf.io()).isTrue();
        Assertions.assertThat(lines).containsExactly((Object[])new String[]{"Hello World", "Foo Bar Baz", "Meep"});
        for (char c : "\nMore text\nNo EOL".toCharArray()) {
            characters.add(Integer.valueOf(c));
        }
        Assertions.assertThat((boolean)buf.io()).isTrue();
        Assertions.assertThat(lines).containsExactly((Object[])new String[]{"Hello World", "Foo Bar Baz", "Meep", "", "More text"});
        buf.flush();
        Assertions.assertThat(lines).containsExactly((Object[])new String[]{"Hello World", "Foo Bar Baz", "Meep", "", "More text", "No EOL"});
    }
}

