/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.runner;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.projectnessie.quarkus.runner.ListenUrlWaiter;

class TestListenUrlWaiter {
    private static ExecutorService executor;

    TestListenUrlWaiter() {
    }

    @BeforeAll
    static void createExecutor() {
        executor = Executors.newCachedThreadPool();
    }

    @AfterAll
    static void stopExecutor() throws Exception {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    @Test
    void ioHandling() {
        AtomicLong clock = new AtomicLong();
        long timeout = 10L;
        AtomicReference<Object> line = new AtomicReference<Object>();
        ListenUrlWaiter waiter = new ListenUrlWaiter(clock::get, timeout, line::set);
        waiter.accept("Hello World");
        Assertions.assertThat((String)line.getAndSet(null)).isEqualTo("Hello World");
        Assertions.assertThat((String)waiter.peekListenUrl()).isNull();
        waiter.accept("");
        Assertions.assertThat((String)line.getAndSet(null)).isEqualTo("");
        Assertions.assertThat((String)waiter.peekListenUrl()).isNull();
        String listenLine = "2021-05-28 12:12:25,753 INFO  [io.quarkus] (main) nessie-quarkus 0.6.2-SNAPSHOT on JVM (powered by Quarkus 1.13.4.Final) started in 1.444s. Listening on: http://0.0.0.0:39423";
        waiter.accept(listenLine);
        Assertions.assertThat((String)line.getAndSet(null)).isEqualTo(listenLine);
        Assertions.assertThat((String)waiter.peekListenUrl()).isEqualTo("http://0.0.0.0:39423");
        listenLine = "2021-05-28 12:12:25,753 INFO  [io.quarkus] (main) nessie-quarkus 0.6.2-SNAPSHOT on JVM (powered by Quarkus 1.13.4.Final) started in 1.444s. Listening on: http://4.2.4.2:4242";
        waiter.accept(listenLine);
        Assertions.assertThat((String)line.getAndSet(null)).isEqualTo(listenLine);
        Assertions.assertThat((String)waiter.peekListenUrl()).isEqualTo("http://0.0.0.0:39423");
        waiter = new ListenUrlWaiter(clock::get, timeout, line::set);
        listenLine = "2021-05-28 12:12:25,753 INFO  [io.quarkus] (main) nessie-quarkus 0.6.2-SNAPSHOT on JVM (powered by Quarkus 1.13.4.Final) started in 1.444s. Listening on: https://localhost.in.some.space:12345";
        waiter.accept(listenLine);
        Assertions.assertThat((String)line.getAndSet(null)).isEqualTo(listenLine);
        Assertions.assertThat((String)waiter.peekListenUrl()).isEqualTo("https://localhost.in.some.space:12345");
        waiter = new ListenUrlWaiter(clock::get, timeout, line::set);
        listenLine = "Listening on: https://localhost.in.some.space:4242";
        waiter.accept(listenLine);
        Assertions.assertThat((String)line.getAndSet(null)).isEqualTo(listenLine);
        Assertions.assertThat((String)waiter.peekListenUrl()).isEqualTo("https://localhost.in.some.space:4242");
    }

    @RepeatedTest(value=20)
    void timeout() {
        AtomicLong clock = new AtomicLong();
        long timeout = 10000L;
        AtomicReference line = new AtomicReference();
        ListenUrlWaiter waiter = new ListenUrlWaiter(clock::get, timeout, line::set);
        Assertions.assertThat((boolean)waiter.isTimeout()).isFalse();
        clock.set(TimeUnit.MILLISECONDS.toNanos(timeout + 1L));
        Assertions.assertThat((boolean)waiter.isTimeout()).isTrue();
        Assertions.assertThat(executor.submit(() -> ((ListenUrlWaiter)waiter).getListenUrl())).failsWithin(5L, TimeUnit.SECONDS).withThrowableOfType(ExecutionException.class).withRootCauseExactlyInstanceOf(TimeoutException.class).withMessageEndingWith("Did not get the http(s) listen URL from the console output.");
    }

    @RepeatedTest(value=20)
    void noTimeout() throws Exception {
        AtomicLong clock = new AtomicLong();
        long timeout = 10000L;
        AtomicReference<Object> line = new AtomicReference<Object>();
        ListenUrlWaiter waiter = new ListenUrlWaiter(clock::get, timeout, line::set);
        clock.set(TimeUnit.MILLISECONDS.toNanos(timeout));
        String listenLine = "2021-05-28 12:12:25,753 INFO  [io.quarkus] (main) nessie-quarkus 0.6.2-SNAPSHOT on JVM (powered by Quarkus 1.13.4.Final) started in 1.444s. Listening on: http://4.2.4.2:4242";
        waiter.accept(listenLine);
        Assertions.assertThat((String)line.getAndSet(null)).isEqualTo(listenLine);
        Assertions.assertThat((String)waiter.getListenUrl()).isEqualTo("http://4.2.4.2:4242");
        Assertions.assertThat((boolean)waiter.isTimeout()).isFalse();
        clock.set(TimeUnit.MILLISECONDS.toNanos(timeout + 1L));
        Assertions.assertThat((String)waiter.getListenUrl()).isEqualTo("http://4.2.4.2:4242");
        Assertions.assertThat((boolean)waiter.isTimeout()).isFalse();
    }
}

