/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.runner;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.projectnessie.quarkus.runner.ProcessHandler;

class TestProcessHandler {
    private static ExecutorService executor;

    TestProcessHandler() {
    }

    @BeforeAll
    static void createExecutor() {
        executor = Executors.newCachedThreadPool();
    }

    @AfterAll
    static void stopExecutor() throws Exception {
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    @Test
    void notStarted() {
        ProcessHandlerMock phMock = new ProcessHandlerMock();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ProcessHandler)phMock.ph).stop()).isInstanceOf(IllegalStateException.class)).hasMessage("No process started");
    }

    @Test
    void doubleStart() {
        ProcessHandlerMock phMock = new ProcessHandlerMock();
        phMock.ph.started(phMock.proc);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> phMock.ph.started(phMock.proc)).isInstanceOf(IllegalStateException.class)).hasMessage("Process already started");
    }

    @RepeatedTest(value=20)
    void processWithNoOutput() {
        ProcessHandlerMock phMock = new ProcessHandlerMock();
        phMock.ph.started(phMock.proc);
        Future<String> futureListenUrl = executor.submit(() -> ((ProcessHandler)phMock.ph).getListenUrl());
        while (phMock.clock.get() < TimeUnit.MILLISECONDS.toNanos(phMock.timeToUrl)) {
            Assertions.assertThat(futureListenUrl).isNotDone();
            phMock.clock.addAndGet(TimeUnit.MILLISECONDS.toNanos(10L));
        }
        phMock.clock.addAndGet(TimeUnit.MILLISECONDS.toNanos(10L));
        Assertions.assertThat(futureListenUrl).failsWithin(5L, TimeUnit.SECONDS).withThrowableOfType(ExecutionException.class).withRootCauseInstanceOf(TimeoutException.class).withMessageEndingWith("Did not get the http(s) listen URL from the console output.");
        phMock.ph.watchdogExitGrace();
        Assertions.assertThat((boolean)phMock.ph.isAlive()).isFalse();
    }

    @RepeatedTest(value=20)
    void processExitsEarly() {
        ProcessHandlerMock phMock = new ProcessHandlerMock();
        phMock.ph.started(phMock.proc);
        Future<String> futureListenUrl = executor.submit(() -> ((ProcessHandler)phMock.ph).getListenUrl());
        Assertions.assertThat((boolean)phMock.ph.isAlive()).isTrue();
        Assertions.assertThatThrownBy(() -> phMock.ph.getExitCode()).isInstanceOf(IllegalThreadStateException.class);
        phMock.exitCode.set(88);
        Assertions.assertThat(futureListenUrl).failsWithin(5L, TimeUnit.SECONDS).withThrowableOfType(ExecutionException.class).withRootCauseInstanceOf(TimeoutException.class).withMessageEndingWith("Did not get the http(s) listen URL from the console output.");
        phMock.ph.watchdogExitGrace();
        Assertions.assertThat(phMock.stderrLines).containsExactly((Object[])new String[]{"Watched process exited with exit-code 88"});
        Assertions.assertThat((boolean)phMock.ph.isAlive()).isFalse();
        Assertions.assertThat((int)phMock.ph.getExitCode()).isEqualTo(88);
    }

    @RepeatedTest(value=20)
    void processLotsOfIoNoListen() {
        ProcessHandlerMock phMock = new ProcessHandlerMock();
        phMock.ph.started(phMock.proc);
        Future<String> futureListenUrl = executor.submit(() -> ((ProcessHandler)phMock.ph).getListenUrl());
        while (phMock.clock.get() < TimeUnit.MILLISECONDS.toNanos(phMock.timeToUrl)) {
            for (char c : "Hello world\n".toCharArray()) {
                phMock.stdout.add((byte)c);
            }
            for (char c : "Errors do not exist\n".toCharArray()) {
                phMock.stderr.add((byte)c);
            }
            Assertions.assertThat(futureListenUrl).isNotDone();
            phMock.clock.addAndGet(TimeUnit.MILLISECONDS.toNanos(10L));
        }
        phMock.clock.addAndGet(TimeUnit.MILLISECONDS.toNanos(10L));
        Assertions.assertThat(futureListenUrl).failsWithin(5L, TimeUnit.SECONDS).withThrowableOfType(ExecutionException.class).withRootCauseInstanceOf(TimeoutException.class).withMessageEndingWith("Did not get the http(s) listen URL from the console output.");
        phMock.ph.watchdogExitGrace();
        Assertions.assertThat((boolean)phMock.ph.isAlive()).isFalse();
        Assertions.assertThat((int)phMock.ph.getExitCode()).isGreaterThanOrEqualTo(0);
        Assertions.assertThat(phMock.stdoutLines).hasSize((int)(phMock.timeToUrl / 10L));
        Assertions.assertThat(phMock.stderrLines).hasSize((int)(phMock.timeToUrl / 10L));
    }

    @RepeatedTest(value=20)
    void processLotsOfIoProperListenUrl() {
        ProcessHandlerMock phMock = new ProcessHandlerMock();
        phMock.ph.started(phMock.proc);
        Future<String> futureListenUrl = executor.submit(() -> ((ProcessHandler)phMock.ph).getListenUrl());
        while (phMock.clock.get() < TimeUnit.MILLISECONDS.toNanos(phMock.timeToUrl / 2L)) {
            for (char c : "Hello world\n".toCharArray()) {
                phMock.stdout.add((byte)c);
            }
            for (char c : "Errors do not exist\n".toCharArray()) {
                phMock.stderr.add((byte)c);
            }
            Assertions.assertThat(futureListenUrl).isNotDone();
            phMock.clock.addAndGet(TimeUnit.MILLISECONDS.toNanos(10L));
        }
        for (char c : "Quarkus startup message... Listening on: http://0.0.0.0:4242\n".toCharArray()) {
            phMock.stdout.add((byte)c);
        }
        phMock.clock.addAndGet(TimeUnit.MILLISECONDS.toNanos(10L));
        Assertions.assertThat(futureListenUrl).succeedsWithin(5L, TimeUnit.SECONDS).isEqualTo((Object)"http://0.0.0.0:4242");
        Assertions.assertThat((boolean)phMock.ph.isAlive()).isTrue();
        Assertions.assertThatThrownBy(() -> phMock.ph.getExitCode()).isInstanceOf(IllegalThreadStateException.class);
        phMock.ph.stop();
        Assertions.assertThat((boolean)phMock.ph.isAlive()).isFalse();
        Assertions.assertThat((int)phMock.ph.getExitCode()).isGreaterThanOrEqualTo(0);
        Assertions.assertThat(phMock.stdoutLines).hasSize((int)(phMock.timeToUrl / 10L / 2L) + 1);
        Assertions.assertThat(phMock.stderrLines).hasSize((int)(phMock.timeToUrl / 10L / 2L));
    }

    static final class ProcessHandlerMock {
        AtomicLong clock = new AtomicLong();
        AtomicInteger exitCode = new AtomicInteger(-1);
        List<String> stderrLines = Collections.synchronizedList(new ArrayList());
        List<String> stdoutLines = Collections.synchronizedList(new ArrayList());
        ArrayBlockingQueue<Byte> stdout = new ArrayBlockingQueue(1024);
        ArrayBlockingQueue<Byte> stderr = new ArrayBlockingQueue(1024);
        InputStream stdoutStream = new InputStream(){

            @Override
            public int available() {
                return stdout.size();
            }

            @Override
            public int read() {
                Byte b = stdout.poll();
                return b == null ? -1 : b.intValue();
            }
        };
        InputStream stderrStream = new InputStream(){

            @Override
            public int available() {
                return stderr.size();
            }

            @Override
            public int read() {
                Byte b = stderr.poll();
                return b == null ? -1 : b.intValue();
            }
        };
        Process proc = new Process(){

            @Override
            public OutputStream getOutputStream() {
                throw new UnsupportedOperationException();
            }

            @Override
            public InputStream getInputStream() {
                return stdoutStream;
            }

            @Override
            public InputStream getErrorStream() {
                return stderrStream;
            }

            @Override
            public int waitFor() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
                return super.waitFor(timeout, unit);
            }

            @Override
            public int exitValue() {
                int ec = exitCode.get();
                if (ec < 0) {
                    throw new IllegalThreadStateException();
                }
                return ec;
            }

            @Override
            public void destroy() {
                exitCode.set(42);
            }

            @Override
            public Process destroyForcibly() {
                exitCode.set(42);
                return this;
            }
        };
        long timeToUrl = 500L;
        ProcessHandler ph = new ProcessHandler().setStderrTarget(this.stderrLines::add).setStdoutTarget(this.stdoutLines::add).setTicker(this.clock::get).setTimeToListenUrlMillis(this.timeToUrl).setTimeStopMillis(42L);

        ProcessHandlerMock() {
        }
    }
}

