/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.runner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavaVM {
    public static final int MAX_JAVA_VERSION_TO_CHECK = 19;
    private static final Pattern MAJOR_VERSION_PATTERN = Pattern.compile("^(1[.])?([0-9]+)([.].+)?$");
    private static final AtomicReference<JavaVM> CURRENT_JVM = new AtomicReference();
    private final Path javaHome;

    static String locateJavaHome(int majorVersion, Function<String, String> getenv, Function<String, String> getProperty, IntFunction<String> macosHelper) {
        String home = getenv.apply(String.format("JDK%d_HOME", majorVersion));
        if (home != null) {
            return home;
        }
        home = getenv.apply(String.format("JAVA%d_HOME", majorVersion));
        if (home != null) {
            return home;
        }
        home = getProperty.apply(String.format("jdk%d.home", majorVersion));
        if (home != null) {
            return home;
        }
        home = getProperty.apply(String.format("java%d.home", majorVersion));
        if (home != null) {
            return home;
        }
        if (getProperty.apply("os.name").toLowerCase(Locale.ROOT).contains("darwin")) {
            return macosHelper.apply(majorVersion);
        }
        return null;
    }

    public static JavaVM findJavaVM(int majorVersion) {
        if (JavaVM.currentJavaVMMajorVersion() >= majorVersion) {
            return JavaVM.getCurrentJavaVM();
        }
        for (int i = majorVersion; i < 19; ++i) {
            JavaVM jvm = JavaVM.findJavaVMTryExact(i);
            if (jvm == null) continue;
            return jvm;
        }
        return null;
    }

    public static JavaVM findJavaVMTryExact(int majorVersion) {
        if (majorVersion == JavaVM.currentJavaVMMajorVersion()) {
            return JavaVM.getCurrentJavaVM();
        }
        String home = JavaVM.locateJavaHome(majorVersion, System::getenv, System::getProperty, ver -> {
            try {
                String versionArg = ver < 9 ? "1." + ver : Integer.toString(ver);
                Process proc = new ProcessBuilder(new String[0]).command("/usr/libexec/java_home", "-v", versionArg).start();
                return new BufferedReader(new InputStreamReader(proc.getInputStream(), Charset.defaultCharset())).readLine();
            }
            catch (IOException e) {
                return null;
            }
        });
        if (home != null) {
            return JavaVM.forJavaHome(home);
        }
        return null;
    }

    public static JavaVM getCurrentJavaVM() {
        JavaVM current = CURRENT_JVM.get();
        if (current == null) {
            current = JavaVM.forJavaHome(Paths.get(System.getProperty("java.home"), new String[0]));
            CURRENT_JVM.set(current);
        }
        return current;
    }

    public static int currentJavaVMMajorVersion() {
        return JavaVM.majorVersionFromString(System.getProperty("java.version"));
    }

    public static int majorVersionFromString(String versionString) {
        Matcher m = MAJOR_VERSION_PATTERN.matcher(versionString);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("%s is not a valid Java version string", versionString));
        }
        return Integer.parseInt(m.group(2));
    }

    static Path fixJavaHome(Path javaHome) {
        Path check;
        if ("jre".equals(javaHome.getFileName().toString()) && Files.isExecutable(javaHome.resolve("bin").resolve(JavaVM.executableName("java"))) && Files.isExecutable((check = javaHome.getParent()).resolve("bin").resolve(JavaVM.executableName("java")))) {
            javaHome = check;
        }
        return javaHome;
    }

    public static JavaVM forJavaHome(String javaHome) {
        return JavaVM.forJavaHome(Paths.get(javaHome, new String[0]));
    }

    public static JavaVM forJavaHome(Path javaHome) {
        return new JavaVM(JavaVM.fixJavaHome(javaHome));
    }

    private JavaVM(Path javaHome) {
        this.javaHome = javaHome;
    }

    public Path getJavaHome() {
        return this.javaHome;
    }

    public Path getJavaExecutable() {
        return this.getExecutable("java");
    }

    private Path getExecutable(String executable) {
        return this.javaHome.resolve("bin").resolve(JavaVM.executableName(executable));
    }

    static String executableName(String executable) {
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows")) {
            return executable + ".exe";
        }
        return executable;
    }
}

