/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.runner;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.projectnessie.quarkus.runner.JavaVM;

class TestJavaVM {
    TestJavaVM() {
    }

    @Test
    void checkJavaVersionStrings() {
        Assertions.assertThat((int)JavaVM.majorVersionFromString((String)"11")).isEqualTo(11);
        Assertions.assertThat((int)JavaVM.majorVersionFromString((String)"17.0.1")).isEqualTo(17);
        Assertions.assertThat((int)JavaVM.majorVersionFromString((String)"1.8.0-foo+bar")).isEqualTo(8);
    }

    @Test
    void checkResolveEnvJdkHomeLinux() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("JDK11_HOME", "/mycomputer/java11");
        env.put("JAVA17_HOME", "/mycomputer/java17");
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put("jdk9.home", "/mycomputer/java9");
        sysProps.put("java10.home", "/mycomputer/java10");
        sysProps.put("os.name", "Linux");
        Assertions.assertThat((String)JavaVM.locateJavaHome((int)8, env::get, sysProps::get, i -> "/hello/there")).isNull();
        Assertions.assertThat((String)JavaVM.locateJavaHome((int)9, env::get, sysProps::get, i -> "/hello/there")).isEqualTo("/mycomputer/java9");
        Assertions.assertThat((String)JavaVM.locateJavaHome((int)10, env::get, sysProps::get, i -> "/hello/there")).isEqualTo("/mycomputer/java10");
        Assertions.assertThat((String)JavaVM.locateJavaHome((int)11, env::get, sysProps::get, i -> "/hello/there")).isEqualTo("/mycomputer/java11");
        Assertions.assertThat((String)JavaVM.locateJavaHome((int)14, env::get, sysProps::get, i -> "/hello/there")).isNull();
        Assertions.assertThat((String)JavaVM.locateJavaHome((int)17, env::get, sysProps::get, i -> "/hello/there")).isEqualTo("/mycomputer/java17");
    }

    @Test
    void checkResolveEnvJdkHomeMacOS() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("JDK11_HOME", "/mycomputer/java11");
        env.put("JAVA17_HOME", "/mycomputer/java17");
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put("jdk9.home", "/mycomputer/java9");
        sysProps.put("java10.home", "/mycomputer/java10");
        sysProps.put("os.name", "Darwin");
        Assertions.assertThat((String)JavaVM.locateJavaHome((int)8, env::get, sysProps::get, i -> i == 8 ? "/from_java_home/v8" : null)).isEqualTo("/from_java_home/v8");
        Assertions.assertThat((String)JavaVM.locateJavaHome((int)9, env::get, sysProps::get, i -> "/hello/there")).isEqualTo("/mycomputer/java9");
        Assertions.assertThat((String)JavaVM.locateJavaHome((int)10, env::get, sysProps::get, i -> "/hello/there")).isEqualTo("/mycomputer/java10");
        Assertions.assertThat((String)JavaVM.locateJavaHome((int)11, env::get, sysProps::get, i -> "/hello/there")).isEqualTo("/mycomputer/java11");
        Assertions.assertThat((String)JavaVM.locateJavaHome((int)14, env::get, sysProps::get, i -> i >= 12 ? "/from_java_home/v16" : null)).isEqualTo("/from_java_home/v16");
        Assertions.assertThat((String)JavaVM.locateJavaHome((int)17, env::get, sysProps::get, i -> i >= 12 ? "/from_java_home/v8" : null)).isEqualTo("/mycomputer/java17");
    }

    @Test
    void checkJreResolve(@TempDir Path jdkDir) throws Exception {
        Path jdkBinDir = jdkDir.resolve("bin");
        Path jdkJavaFile = jdkBinDir.resolve(JavaVM.executableName((String)"java"));
        Path jreDir = jdkDir.resolve("jre");
        Path jreBinDir = jreDir.resolve("bin");
        Path jreJavaFile = jreBinDir.resolve(JavaVM.executableName((String)"java"));
        Files.createDirectories(jdkBinDir, new FileAttribute[0]);
        Files.createDirectories(jreBinDir, new FileAttribute[0]);
        Files.createFile(jreJavaFile, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-x---")));
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("JDK8_HOME", jreDir.toString());
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put("os.name", "Linux");
        Assertions.assertThat((String)JavaVM.locateJavaHome((int)8, env::get, sysProps::get, x -> null)).isEqualTo(jreDir.toString());
        Assertions.assertThat((Path)JavaVM.fixJavaHome((Path)jreDir)).isEqualTo((Object)jreDir);
        Assertions.assertThat((Path)JavaVM.forJavaHome((Path)jreDir).getJavaExecutable()).isEqualTo((Object)jreJavaFile);
        Assertions.assertThat((Path)JavaVM.forJavaHome((Path)jreDir).getJavaHome()).isEqualTo((Object)jreDir);
        Assertions.assertThat((Path)JavaVM.forJavaHome((String)jreDir.toString()).getJavaHome()).isEqualTo((Object)jreDir);
        Files.createFile(jdkJavaFile, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-x---")));
        Assertions.assertThat((Path)JavaVM.fixJavaHome((Path)jreDir)).isEqualTo((Object)jdkDir);
        Assertions.assertThat((Path)JavaVM.forJavaHome((Path)jreDir).getJavaExecutable()).isEqualTo((Object)jdkJavaFile);
        Assertions.assertThat((Path)JavaVM.forJavaHome((Path)jreDir).getJavaHome()).isEqualTo((Object)jdkDir);
        Assertions.assertThat((Path)JavaVM.forJavaHome((String)jreDir.toString()).getJavaHome()).isEqualTo((Object)jdkDir);
    }
}

