/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;
import scala.collection.Map;
import scala.collection.Seq;

public abstract class AbstractSparkTest {
    @TempDir
    File tempFile;
    private static final int NESSIE_PORT = Integer.getInteger("quarkus.http.test-port", 19121);
    protected static SparkConf conf = new SparkConf();
    protected static SparkSession spark;
    protected static String url;

    @BeforeEach
    protected void create() {
        ImmutableMap nessieParams = ImmutableMap.of((Object)"ref", (Object)"main", (Object)"uri", (Object)url, (Object)"warehouse", (Object)this.tempFile.toURI().toString());
        nessieParams.forEach((k, v) -> {
            conf.set(String.format("spark.sql.catalog.nessie.%s", k), v);
            conf.set(String.format("spark.sql.catalog.spark_catalog.%s", k), v);
        });
        conf.set(SQLConf.PARTITION_OVERWRITE_MODE().key(), "dynamic").set("spark.testing", "true").set("spark.sql.shuffle.partitions", "4").set("spark.sql.catalog.hive", "org.apache.iceberg.spark.SparkCatalog").set("spark.sql.catalog.hive.catalog-impl", "org.apache.iceberg.hive.HiveCatalog").set("spark.sql.catalog.nessie.catalog-impl", "org.apache.iceberg.nessie.NessieCatalog").set("spark.sql.catalog.nessie", "org.apache.iceberg.spark.SparkCatalog");
        spark = SparkSession.builder().master("local[2]").config(conf).getOrCreate();
        spark.sparkContext().setLogLevel("WARN");
    }

    @AfterAll
    static void tearDown() throws Exception {
        if (spark != null) {
            spark.stop();
            spark = null;
        }
    }

    protected static List<Object[]> transform(Dataset<Row> table) {
        return table.collectAsList().stream().map(row -> IntStream.range(0, row.size()).mapToObj(pos -> row.isNullAt(pos) ? null : row.get(pos)).toArray(Object[]::new)).collect(Collectors.toList());
    }

    protected static void assertEquals(String context, Object[] expectedRow, List<Object[]> actualRows) {
        AbstractSparkTest.assertEquals(context, Collections.singletonList(expectedRow), actualRows);
    }

    protected static void assertEquals(String context, List<Object[]> expectedRows, List<Object[]> actualRows) {
        ((ListAssert)Assertions.assertThat(actualRows).as("%s", new Object[]{context})).containsExactlyElementsOf(expectedRows);
    }

    protected static List<Object[]> sql(String query, Object ... args) {
        List rows = spark.sql(String.format(query, args)).collectAsList();
        if (rows.size() < 1) {
            return ImmutableList.of();
        }
        return rows.stream().map(AbstractSparkTest::toJava).collect(Collectors.toList());
    }

    protected static Object[] toJava(Row row) {
        return IntStream.range(0, row.size()).mapToObj(pos -> {
            if (row.isNullAt(pos)) {
                return null;
            }
            Object value = row.get(pos);
            if (value instanceof Row) {
                return AbstractSparkTest.toJava((Row)value);
            }
            if (value instanceof Seq) {
                return row.getList(pos);
            }
            if (value instanceof Map) {
                return row.getJavaMap(pos);
            }
            return value;
        }).toArray(Object[]::new);
    }

    protected static Object[] row(Object ... values) {
        return values;
    }

    static {
        url = String.format("http://localhost:%d/api/v1", NESSIE_PORT);
    }
}

