/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client.tests;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractSparkTest {
    private static final Object ANY = new Object();
    private static final int NESSIE_PORT = Integer.getInteger("quarkus.http.test-port", 19121);
    protected static SparkConf conf = new SparkConf();
    protected static SparkSession spark;
    protected static Configuration hadoopConfig;
    protected static String url;

    @BeforeEach
    protected void create() throws IOException {
        String branch = "main";
        String authType = "NONE";
        hadoopConfig.set("nessie.url", url);
        hadoopConfig.set("nessie.ref", branch);
        hadoopConfig.set("nessie.auth_type", authType);
        conf.set("spark.hadoop.nessie.url", url).set("spark.hadoop.nessie.ref", branch).set("spark.hadoop.nessie.auth_type", authType).set(SQLConf.PARTITION_OVERWRITE_MODE().key(), "dynamic");
        spark = SparkSession.builder().master("local[2]").config(conf).getOrCreate();
        spark.sparkContext().setLogLevel("WARN");
    }

    @AfterAll
    static void tearDown() throws Exception {
        if (spark != null) {
            spark.stop();
            spark = null;
        }
    }

    protected static List<Object[]> transform(Dataset<Row> table) {
        return table.collectAsList().stream().map(row -> IntStream.range(0, row.size()).mapToObj(pos -> row.isNullAt(pos) ? null : row.get(pos)).toArray(Object[]::new)).collect(Collectors.toList());
    }

    protected static void assertEquals(String context, List<Object[]> expectedRows, List<Object[]> actualRows) {
        Assertions.assertEquals((int)expectedRows.size(), (int)actualRows.size(), (String)(context + ": number of results should match"));
        for (int row = 0; row < expectedRows.size(); ++row) {
            Object[] expected = expectedRows.get(row);
            Object[] actual = actualRows.get(row);
            Assertions.assertEquals((int)expected.length, (int)actual.length, (String)"Number of columns should match");
            for (int col = 0; col < actualRows.get(row).length; ++col) {
                if (expected[col] == ANY) continue;
                Assertions.assertEquals((Object)expected[col], (Object)actual[col], (String)(context + ": row " + row + " col " + col + " contents should match"));
            }
        }
    }

    static {
        hadoopConfig = new Configuration();
        url = String.format("http://localhost:%d/api/v1", NESSIE_PORT);
    }
}

