/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client;

import com.dremio.nessie.api.TreeApi;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Branch;
import com.dremio.nessie.model.EntriesResponse;
import com.dremio.nessie.model.LogResponse;
import com.dremio.nessie.model.Merge;
import com.dremio.nessie.model.MultiContents;
import com.dremio.nessie.model.MultiGetContentsRequest;
import com.dremio.nessie.model.MultiGetContentsResponse;
import com.dremio.nessie.model.Reference;
import com.dremio.nessie.model.Transplant;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;

class ClientTreeApi
implements TreeApi {
    private static final GenericType<List<Reference>> REFERENCE_LIST = new GenericType<List<Reference>>(){};
    private final WebTarget target;

    public ClientTreeApi(WebTarget target) {
        this.target = target;
    }

    public List<Reference> getAllReferences() {
        return (List)this.target.path("trees").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get().readEntity(REFERENCE_LIST);
    }

    public Reference getReferenceByName(@NotNull String refName) throws NessieNotFoundException {
        return (Reference)this.target.path("trees").path("tree").path(refName).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get().readEntity(Reference.class);
    }

    public void createEmptyTag(String tagName) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees").path("tag").path(tagName).request().post(Entity.entity(null, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void createNewTag(@NotNull String tagName, String hash) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees").path("tag").path(tagName).path(hash).request().post(Entity.entity(null, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void assignTag(@NotNull String tagName, @NotNull String oldHash, @NotNull String newHash) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees").path("tag").path(tagName).path(oldHash).path(newHash).request().put(Entity.entity(null, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void deleteTag(@NotNull String tagName, @NotNull String hash) throws NessieConflictException, NessieNotFoundException {
        this.target.path("trees").path("tag").path(tagName).path(hash).request().delete();
    }

    public void createEmptyBranch(@NotNull String branchName) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees").path("branch").path(branchName).request().post(Entity.entity(null, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void createNewBranch(@NotNull String branchName, @NotNull String hash) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees").path("branch").path(branchName).path(hash).request().post(Entity.json(null));
    }

    public void assignBranch(@NotNull String branchName, @NotNull String oldHash, @NotNull String newHash) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees").path("branch").path(branchName).path(oldHash).path(newHash).request().put(Entity.entity((Object)"", (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void deleteBranch(@NotNull String branchName, @NotNull String hash) throws NessieConflictException, NessieNotFoundException {
        this.target.path("trees").path("branch").path(branchName).path(hash).request().delete();
    }

    public Branch getDefaultBranch() {
        return (Branch)this.target.path("trees").path("tree").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get().readEntity(Branch.class);
    }

    public LogResponse getCommitLog(@NotNull String ref) throws NessieNotFoundException {
        return (LogResponse)this.target.path("trees").path("tree").path(ref).path("log").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get().readEntity(LogResponse.class);
    }

    public void transplantCommitsIntoBranch(String message, Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees").path("transplant").queryParam("message", new Object[]{message}).request().put(Entity.entity((Object)transplant, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void mergeRefIntoBranch(@NotNull Merge merge) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees").path("merge").request().put(Entity.entity((Object)merge, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public EntriesResponse getEntries(@NotNull String refName) throws NessieNotFoundException {
        return (EntriesResponse)this.target.path("trees").path("tree").path(refName).path("entries").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get().readEntity(EntriesResponse.class);
    }

    public MultiGetContentsResponse getMultipleContents(@NotNull String ref, @NotNull MultiGetContentsRequest request) throws NessieNotFoundException {
        return (MultiGetContentsResponse)this.target.path("trees").path("multi").path(ref).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)request, (MediaType)MediaType.APPLICATION_JSON_TYPE)).readEntity(MultiGetContentsResponse.class);
    }

    public void commitMultipleOperations(@NotNull String hash, String message, @NotNull MultiContents operations) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees").path("multi").path(hash).queryParam("message", new Object[]{message}).request().put(Entity.entity((Object)operations, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void commitMultipleOperations(String branch, @NotNull String hash, String message, @NotNull MultiContents operations) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees").path("multi").path(branch).path(hash).queryParam("message", new Object[]{message}).request().put(Entity.entity((Object)operations, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }
}

