/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client.rest;

import com.dremio.nessie.client.rest.NessieBadRequestException;
import com.dremio.nessie.client.rest.NessieForbiddenException;
import com.dremio.nessie.client.rest.NessieInternalServerException;
import com.dremio.nessie.client.rest.NessieNotAuthorizedException;
import com.dremio.nessie.client.rest.NessieServiceException;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieError;
import com.dremio.nessie.error.NessieNotFoundException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;

public class ResponseCheckFilter
implements ClientResponseFilter {
    private static final ObjectReader READER = new ObjectMapper().readerFor(NessieError.class);

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        ResponseCheckFilter.checkResponse(responseContext.getStatus(), responseContext);
    }

    public static void checkResponse(int statusCode, ClientResponseContext cntxt) throws IOException {
        if (statusCode > 199 && statusCode < 300) {
            return;
        }
        NessieError error = ResponseCheckFilter.decodeErrorObject(cntxt);
        switch (error.getStatus()) {
            case NOT_FOUND: {
                throw new NessieNotFoundException(error);
            }
            case CONFLICT: {
                throw new NessieConflictException(error);
            }
            case BAD_REQUEST: {
                throw new NessieBadRequestException(error);
            }
            case UNAUTHORIZED: {
                throw new NessieNotAuthorizedException(error);
            }
            case FORBIDDEN: {
                throw new NessieForbiddenException(error);
            }
            case INTERNAL_SERVER_ERROR: {
                throw new NessieInternalServerException(error);
            }
        }
        throw new NessieServiceException(error);
    }

    private static NessieError decodeErrorObject(ClientResponseContext response) {
        NessieError error;
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        InputStream inputStream = response.getEntityStream();
        if (inputStream == null) {
            error = new NessieError(status.getReasonPhrase(), status, null, (Exception)new RuntimeException("Could not parse error object in response."));
        } else {
            try {
                error = (NessieError)READER.readValue(inputStream);
            }
            catch (IOException e) {
                error = new NessieError(status.getReasonPhrase(), status, null, (Exception)e);
            }
        }
        return error;
    }
}

