/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.ResultStreamPaginator;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.PaginatedResponse;

class TestResultStreamPaginator {
    TestResultStreamPaginator() {
    }

    @Test
    void testNotFoundException() {
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> {
            throw new NessieNotFoundException("Ref not found");
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> paginator.generateStream("ref", OptionalInt.empty())).isInstanceOf(NessieNotFoundException.class)).hasMessage("Ref not found");
    }

    @Test
    void testNoPageSizeHint1Page() throws Exception {
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> {
            org.junit.jupiter.api.Assertions.assertNull((Object)pageSize);
            org.junit.jupiter.api.Assertions.assertNull((Object)token);
            return new MockPaginatedResponse(false, null, Arrays.asList("1", "2", "3"));
        });
        Assertions.assertThat((Stream)paginator.generateStream("ref", OptionalInt.empty())).containsExactly((Object[])new String[]{"1", "2", "3"});
    }

    @Test
    void testNoPageSizeHint2Pages() throws Exception {
        Iterator<String> expectedTokens = Arrays.asList(null, "token").iterator();
        Iterator<MockPaginatedResponse> responses = Arrays.asList(new MockPaginatedResponse(true, "token", Arrays.asList("1", "2", "3")), new MockPaginatedResponse(false, null, Arrays.asList("4", "5", "6"))).iterator();
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> {
            org.junit.jupiter.api.Assertions.assertNull((Object)pageSize);
            org.junit.jupiter.api.Assertions.assertEquals(expectedTokens.next(), (Object)token);
            return (MockPaginatedResponse)responses.next();
        });
        Assertions.assertThat((Stream)paginator.generateStream("ref", OptionalInt.empty())).containsExactly((Object[])new String[]{"1", "2", "3", "4", "5", "6"});
    }

    @Test
    void testPageSizeHint1Page() throws Exception {
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> {
            org.junit.jupiter.api.Assertions.assertEquals((int)5, (Integer)pageSize);
            org.junit.jupiter.api.Assertions.assertNull((Object)token);
            return new MockPaginatedResponse(false, null, Arrays.asList("1", "2", "3"));
        });
        Assertions.assertThat((Stream)paginator.generateStream("ref", OptionalInt.of(5))).containsExactly((Object[])new String[]{"1", "2", "3"});
    }

    @Test
    void testPageSizeHint2Pages() throws Exception {
        Iterator<String> expectedTokens = Arrays.asList(null, "token").iterator();
        Iterator<MockPaginatedResponse> responses = Arrays.asList(new MockPaginatedResponse(true, "token", Arrays.asList("1", "2", "3")), new MockPaginatedResponse(false, null, Arrays.asList("4", "5", "6"))).iterator();
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> {
            org.junit.jupiter.api.Assertions.assertEquals((int)5, (Integer)pageSize);
            org.junit.jupiter.api.Assertions.assertEquals(expectedTokens.next(), (Object)token);
            return (MockPaginatedResponse)responses.next();
        });
        Assertions.assertThat((Stream)paginator.generateStream("ref", OptionalInt.of(5))).containsExactly((Object[])new String[]{"1", "2", "3", "4", "5", "6"});
    }

    @Test
    void testEmptyResult() throws Exception {
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> new MockPaginatedResponse(false, null, Collections.emptyList()));
        Assertions.assertThat((Stream)paginator.generateStream("ref", OptionalInt.of(5))).isEmpty();
    }

    @Test
    void testEmptyResultInPage() throws Exception {
        Iterator<String> expectedTokens = Arrays.asList(null, "token").iterator();
        Iterator<MockPaginatedResponse> responses = Arrays.asList(new MockPaginatedResponse(true, "token", Arrays.asList("1", "2", "3")), new MockPaginatedResponse(false, null, Collections.emptyList())).iterator();
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> {
            org.junit.jupiter.api.Assertions.assertEquals((int)5, (Integer)pageSize);
            org.junit.jupiter.api.Assertions.assertEquals(expectedTokens.next(), (Object)token);
            return (MockPaginatedResponse)responses.next();
        });
        Assertions.assertThat((Stream)paginator.generateStream("ref", OptionalInt.of(5))).containsExactly((Object[])new String[]{"1", "2", "3"});
    }

    @Test
    void testEmptyResultButMoreInPage() {
        Iterator<String> expectedTokens = Arrays.asList(null, "token").iterator();
        Iterator<MockPaginatedResponse> responses = Arrays.asList(new MockPaginatedResponse(true, "token", Arrays.asList("1", "2", "3")), new MockPaginatedResponse(true, "wtf", Collections.emptyList())).iterator();
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> {
            org.junit.jupiter.api.Assertions.assertEquals((int)5, (Integer)pageSize);
            org.junit.jupiter.api.Assertions.assertEquals(expectedTokens.next(), (Object)token);
            return (MockPaginatedResponse)responses.next();
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> paginator.generateStream("ref", OptionalInt.of(5)).collect(Collectors.toList())).isInstanceOf(IllegalStateException.class)).hasMessage("Backend returned empty page, but indicates there are more results");
    }

    private static class MockPaginatedResponse
    implements PaginatedResponse {
        private final boolean more;
        private final String token;
        private final List<String> elements;

        public MockPaginatedResponse(boolean more, String token, List<String> elements) {
            this.more = more;
            this.token = token;
            this.elements = elements;
        }

        List<String> getElements() {
            return this.elements;
        }

        public boolean isHasMore() {
            return this.more;
        }

        @Nullable
        public String getToken() {
            return this.token;
        }
    }
}

