/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;
import org.projectnessie.client.auth.BearerAuthenticationProvider;
import org.projectnessie.client.auth.NessieAuthentication;
import org.projectnessie.client.auth.NessieAuthenticationProvider;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.RequestFilter;

class TestBearerAuthenticationProvider {
    TestBearerAuthenticationProvider() {
    }

    private BearerAuthenticationProvider provider() {
        return new BearerAuthenticationProvider();
    }

    @Test
    void testNullParams() {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThatThrownBy(() -> this.provider().build(prop -> null)).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> BearerAuthenticationProvider.create(null)).isInstanceOf(NullPointerException.class)});
    }

    @Test
    void testFromConfig() {
        ImmutableMap authCfg = ImmutableMap.of((Object)"nessie.authentication.type", (Object)"BEARER", (Object)"nessie.authentication.token", (Object)"token123");
        NessieAuthentication authentication = NessieAuthenticationProvider.fromConfig(((Map)authCfg)::get);
        this.checkAuth(authentication);
    }

    @Test
    void testStaticBuilder() {
        this.checkAuth((NessieAuthentication)BearerAuthenticationProvider.create((String)"token123"));
    }

    void checkAuth(NessieAuthentication authentication) {
        Assertions.assertThat((Object)authentication).isInstanceOf(HttpAuthentication.class);
        HttpAuthentication httpAuthentication = (HttpAuthentication)authentication;
        RequestFilter[] authFilter = new RequestFilter[1];
        HttpClient client = (HttpClient)Mockito.mock(HttpClient.class);
        ((HttpClient)Mockito.doAnswer(invocationOnMock -> {
            Object[] args = invocationOnMock.getArguments();
            if (args.length == 1 && args[0] instanceof RequestFilter) {
                authFilter[0] = (RequestFilter)args[0];
            }
            return null;
        }).when((Object)client)).register((RequestFilter)Mockito.any());
        httpAuthentication.applyToHttpClient(client);
        Assertions.assertThat((Object)authFilter[0]).isInstanceOf(RequestFilter.class);
        HashMap map = new HashMap();
        RequestContext context = new RequestContext(map, null, null, null);
        authFilter[0].filter(context);
        ((IterableAssert)((MapAssert)Assertions.assertThat(map).containsKey((Object)"Authorization")).extracting("Authorization", InstanceOfAssertFactories.iterable(String.class))).containsExactly((Object[])new String[]{"Bearer token123"});
    }
}

