/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableEntriesResponse;
import org.projectnessie.model.ImmutableEntry;
import org.projectnessie.model.ImmutableLogResponse;
import org.projectnessie.model.ImmutableMerge;
import org.projectnessie.model.ImmutableTransplant;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Merge;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Transplant;

public class TestModelObjectsSerialization {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String HASH = "3e1cfa82b035c26cbbbdae632cea070514eb8b773f616aaeaf668e2f0be8f10e";

    @ParameterizedTest
    @MethodSource(value={"goodCases"})
    void testGoodSerDeCases(Case goodCase) throws IOException {
        String json = MAPPER.writeValueAsString(goodCase.obj);
        Assertions.assertThat((String)json).isEqualTo(goodCase.deserializedJson);
        Object deserialized = MAPPER.readValue(json, goodCase.deserializeAs);
        Assertions.assertThat((Object)deserialized).isEqualTo(goodCase.obj);
    }

    @ParameterizedTest
    @MethodSource(value={"negativeCases"})
    void testNegativeSerDeCases(Case invalidCase) {
        Assertions.assertThatThrownBy(() -> MAPPER.readValue(invalidCase.deserializedJson, invalidCase.deserializeAs)).isInstanceOf(JsonProcessingException.class);
    }

    static List<Case> goodCases() {
        Instant now = Instant.now();
        String branchName = "testBranch";
        return Arrays.asList(new Case(Branch.of((String)"testBranch", (String)HASH), Branch.class, Json.from("type", "BRANCH").add("name", "testBranch").add("hash", HASH)), new Case(Branch.of((String)"testBranch", null), Branch.class, Json.from("type", "BRANCH").add("name", "testBranch").addNoQuotes("hash", "null")), new Case(Tag.of((String)"tagname", (String)HASH), Tag.class, Json.from("type", "TAG").add("name", "tagname").add("hash", HASH)), new Case(ImmutableTransplant.builder().addHashesToTransplant(HASH).fromRefName("testBranch").build(), Transplant.class, Json.arr("hashesToTransplant", HASH).add("fromRefName", "testBranch")), new Case(ImmutableEntriesResponse.builder().addEntries((EntriesResponse.Entry)ImmutableEntry.builder().type(Content.Type.ICEBERG_TABLE).name(ContentKey.fromPathString((String)"/tmp/testpath")).build()).token(HASH).isHasMore(true).build(), EntriesResponse.class, Json.from("token", HASH).addArrNoQuotes("entries", Json.from("type", "ICEBERG_TABLE").addNoQuotes("name", Json.arr("elements", "/tmp/testpath"))).addNoQuotes("hasMore", true)), new Case(ImmutableLogResponse.builder().addOperations(new CommitMeta[0]).token(HASH).addOperations((CommitMeta)ImmutableCommitMeta.builder().commitTime(now).author("author@example.com").committer("committer@example.com").authorTime(now).hash(HASH).message("test commit").putProperties("prop1", "val1").signedOffBy("signer@example.com").build()).isHasMore(true).build(), LogResponse.class, Json.from("token", HASH).addArrNoQuotes("operations", Json.from("hash", HASH).add("committer", "committer@example.com").add("author", "author@example.com").add("signedOffBy", "signer@example.com").add("message", "test commit").add("commitTime", now.toString()).add("authorTime", now.toString()).addNoQuotes("properties", Json.from("prop1", "val1"))).addNoQuotes("hasMore", true)), new Case(ImmutableMerge.builder().fromHash(HASH).fromRefName("testBranch").build(), Merge.class, Json.from("fromHash", HASH).add("fromRefName", "testBranch")));
    }

    static List<Case> negativeCases() {
        return Arrays.asList(new Case(Branch.class, Json.from("type", "BRANCH").add("name", "$p@c!@L").add("hash", HASH)), new Case(Branch.class, Json.from("type", "BRANCH").add("name", "testBranch").add("hash", "invalidhash")), new Case(Branch.class, Json.from("type", "BRANCH").addNoQuotes("name", "null").add("hash", HASH)), new Case(Transplant.class, Json.arr("hashesToTransplant", "invalidhash").addNoQuotes("fromRefName", "null")), new Case(Transplant.class, Json.arr("hashesToTransplant", "invalidhash").add("fromRefName", "testBranch")), new Case(Tag.class, Json.from("type", "TAG").add("name", "tagname").add("hash", "invalidhash")));
    }

    static class Json {
        private static final String STR_KV_FORMAT = "%s,\"%s\":\"%s\"";
        private static final String NO_QUOTES_KV_FORMAT = "%s,\"%s\":%s";
        String currentContent;

        private Json(String currentContent) {
            this.currentContent = currentContent;
        }

        static Json from(String key, String val) {
            return new Json(String.format("\"%s\":\"%s\"", key, val));
        }

        static Json noQuotes(String key, Object val) {
            return new Json(String.format("\"%s\":%s", key, val));
        }

        static Json arr(String key, String ... val) {
            String currentContent = Stream.of(val).collect(Collectors.joining("\",\"", String.format("\"%s\":[\"", key), "\"]"));
            return new Json(currentContent);
        }

        public Json add(String key, String val) {
            this.currentContent = String.format(STR_KV_FORMAT, this.currentContent, key, val);
            return this;
        }

        public Json addArrNoQuotes(String key, Object ... val) {
            String keyContent = Stream.of(val).map(Object::toString).collect(Collectors.joining(",", String.format("\"%s\":[", key), "]"));
            this.currentContent = String.format("%s,%s", this.currentContent, keyContent);
            return this;
        }

        public Json addNoQuotes(String key, Object val) {
            this.currentContent = String.format(NO_QUOTES_KV_FORMAT, this.currentContent, key, val.toString());
            return this;
        }

        public String toString() {
            return String.format("{%s}", this.currentContent);
        }
    }

    static class Case {
        final Object obj;
        final Class<?> deserializeAs;
        final String deserializedJson;

        public Case(Class<?> deserializeAs, Json deserializedJson) {
            this(null, deserializeAs, deserializedJson);
        }

        public Case(Object obj, Class<?> deserializeAs, Json deserializedJson) {
            this.obj = obj;
            this.deserializeAs = deserializeAs;
            this.deserializedJson = deserializedJson.toString();
        }

        public String toString() {
            return this.deserializeAs.getName() + " : " + this.obj;
        }
    }
}

