/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import java.util.OptionalInt;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.projectnessie.client.ResultStreamPaginator;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.PagingBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;

public final class StreamingUtil {
    private StreamingUtil() {
    }

    public static Stream<Reference> getAllReferencesStream(@NotNull NessieApiV1 api, OptionalInt maxRecords) throws NessieNotFoundException {
        return new ResultStreamPaginator(ReferencesResponse::getReferences, (r, pageSize, token) -> StreamingUtil.builderWithPaging(api.getAllReferences(), pageSize, token).get()).generateStream(null, maxRecords);
    }

    public static Stream<EntriesResponse.Entry> getEntriesStream(@NotNull NessieApiV1 api, @NotNull String ref, @Nullable String hashOnRef, @Nullable String queryExpression, OptionalInt maxRecords) throws NessieNotFoundException {
        return new ResultStreamPaginator(EntriesResponse::getEntries, (ref1, pageSize, token) -> ((GetEntriesBuilder)((GetEntriesBuilder)((GetEntriesBuilder)StreamingUtil.builderWithPaging(api.getEntries(), pageSize, token).refName(ref1)).hashOnRef(hashOnRef)).queryExpression(queryExpression)).get()).generateStream(ref, maxRecords);
    }

    public static Stream<CommitMeta> getCommitLogStream(@NotNull NessieApiV1 api, @NotNull String ref, @Nullable String hashOnRef, @Nullable String untilHash, @Nullable String queryExpression, OptionalInt maxRecords) throws NessieNotFoundException {
        return new ResultStreamPaginator(LogResponse::getOperations, (reference, pageSize, token) -> ((GetCommitLogBuilder)((GetCommitLogBuilder)((GetCommitLogBuilder)StreamingUtil.builderWithPaging(api.getCommitLog(), pageSize, token).refName(reference)).hashOnRef(hashOnRef)).queryExpression(queryExpression)).untilHash(untilHash).get()).generateStream(ref, maxRecords);
    }

    private static <B extends PagingBuilder<B>> B builderWithPaging(B builder, Integer pageSize, String token) {
        if (pageSize != null) {
            builder.maxRecords(pageSize);
        }
        if (token != null) {
            builder.pageToken(token);
        }
        return builder;
    }
}

