/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpClientReadTimeoutException;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.Status;
import org.projectnessie.client.util.TestServer;
import org.projectnessie.model.CommitMeta;

public class TestHttpClient {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Instant NOW = Instant.now();

    private static HttpRequest get(InetSocketAddress address) {
        return TestHttpClient.get(address, 15000, 15000);
    }

    private static HttpRequest get(InetSocketAddress address, int connectTimeout, int readTimeout) {
        return HttpClient.builder().setBaseUri(URI.create("http://localhost:" + address.getPort())).setObjectMapper(MAPPER).setConnectionTimeoutMillis(connectTimeout).setReadTimeoutMillis(readTimeout).build().newRequest();
    }

    @Test
    void testGet() throws Exception {
        ExampleBean inputBean = new ExampleBean("x", 1, NOW);
        HttpHandler handler = h -> {
            Assertions.assertEquals((Object)"GET", (Object)h.getRequestMethod());
            String response = MAPPER.writeValueAsString((Object)inputBean);
            h.sendResponseHeaders(200, response.getBytes().length);
            OutputStream os = h.getResponseBody();
            os.write(response.getBytes());
            os.close();
        };
        try (TestServer server = new TestServer(handler);){
            ExampleBean bean = (ExampleBean)TestHttpClient.get(server.getAddress()).get().readEntity(ExampleBean.class);
            Assertions.assertEquals((Object)inputBean, (Object)bean);
        }
    }

    @Test
    void testReadTimeout() {
        HttpHandler handler = h -> {};
        Assertions.assertThrows(HttpClientReadTimeoutException.class, () -> {
            try (TestServer server = new TestServer(handler);){
                TestHttpClient.get(server.getAddress(), 15000, 1).get().readEntity(ExampleBean.class);
            }
        });
    }

    @Test
    void testPut() throws Exception {
        ExampleBean inputBean = new ExampleBean("x", 1, NOW);
        HttpHandler handler = h -> {
            Assertions.assertEquals((Object)"PUT", (Object)h.getRequestMethod());
            Object bean = MAPPER.readerFor(ExampleBean.class).readValue(h.getRequestBody());
            Assertions.assertEquals((Object)inputBean, (Object)bean);
            h.sendResponseHeaders(200, 0L);
        };
        try (TestServer server = new TestServer(handler);){
            TestHttpClient.get(server.getAddress()).put((Object)inputBean);
        }
    }

    @Test
    void testPost() throws Exception {
        ExampleBean inputBean = new ExampleBean("x", 1, NOW);
        HttpHandler handler = h -> {
            Assertions.assertEquals((Object)"POST", (Object)h.getRequestMethod());
            Object bean = MAPPER.readerFor(ExampleBean.class).readValue(h.getRequestBody());
            Assertions.assertEquals((Object)inputBean, (Object)bean);
            h.sendResponseHeaders(200, 0L);
        };
        try (TestServer server = new TestServer(handler);){
            TestHttpClient.get(server.getAddress()).post((Object)inputBean);
        }
    }

    @Test
    void testDelete() throws Exception {
        HttpHandler handler = h -> {
            Assertions.assertEquals((Object)"DELETE", (Object)h.getRequestMethod());
            h.sendResponseHeaders(200, 0L);
        };
        try (TestServer server = new TestServer(handler);){
            TestHttpClient.get(server.getAddress()).delete();
        }
    }

    @Test
    void testGetQueryParam() throws Exception {
        ExampleBean inputBean = new ExampleBean("x", 1, NOW);
        HttpHandler handler = h -> {
            Assertions.assertEquals((Object)"x=y", (Object)h.getRequestURI().getQuery());
            Assertions.assertEquals((Object)"GET", (Object)h.getRequestMethod());
            String response = MAPPER.writeValueAsString((Object)inputBean);
            h.sendResponseHeaders(200, response.getBytes().length);
            OutputStream os = h.getResponseBody();
            os.write(response.getBytes());
            os.close();
        };
        try (TestServer server = new TestServer(handler);){
            ExampleBean bean = (ExampleBean)TestHttpClient.get(server.getAddress()).queryParam("x", "y").get().readEntity(ExampleBean.class);
            Assertions.assertEquals((Object)inputBean, (Object)bean);
        }
    }

    @Test
    void testGetMultipleQueryParam() throws Exception {
        ExampleBean inputBean = new ExampleBean("x", 1, NOW);
        HttpHandler handler = h -> {
            String[] queryParams = h.getRequestURI().getQuery().split("&");
            Assertions.assertEquals((int)2, (int)queryParams.length);
            HashSet<String> queryParamSet = new HashSet<String>(Arrays.asList(queryParams));
            Assertions.assertTrue((boolean)queryParamSet.contains("x=y"));
            Assertions.assertTrue((boolean)queryParamSet.contains("a=b"));
            Assertions.assertEquals((Object)"GET", (Object)h.getRequestMethod());
            String response = MAPPER.writeValueAsString((Object)inputBean);
            h.sendResponseHeaders(200, response.getBytes().length);
            OutputStream os = h.getResponseBody();
            os.write(response.getBytes());
            os.close();
        };
        try (TestServer server = new TestServer(handler);){
            ExampleBean bean = (ExampleBean)TestHttpClient.get(server.getAddress()).queryParam("x", "y").queryParam("a", "b").get().readEntity(ExampleBean.class);
            Assertions.assertEquals((Object)inputBean, (Object)bean);
        }
    }

    @Test
    void testGetNullQueryParam() throws Exception {
        ExampleBean inputBean = new ExampleBean("x", 1, NOW);
        HttpHandler handler = h -> {
            String queryParams = h.getRequestURI().getQuery();
            Assertions.assertNull((Object)queryParams);
            Assertions.assertEquals((Object)"GET", (Object)h.getRequestMethod());
            String response = MAPPER.writeValueAsString((Object)inputBean);
            h.sendResponseHeaders(200, response.getBytes().length);
            OutputStream os = h.getResponseBody();
            os.write(response.getBytes());
            os.close();
        };
        try (TestServer server = new TestServer(handler);){
            ExampleBean bean = (ExampleBean)TestHttpClient.get(server.getAddress()).queryParam("x", null).get().readEntity(ExampleBean.class);
            Assertions.assertEquals((Object)inputBean, (Object)bean);
        }
    }

    @Test
    void testGetTemplate() throws Exception {
        ExampleBean inputBean = new ExampleBean("x", 1, NOW);
        HttpHandler handler = h -> {
            Assertions.assertEquals((Object)"GET", (Object)h.getRequestMethod());
            String response = MAPPER.writeValueAsString((Object)inputBean);
            h.sendResponseHeaders(200, response.getBytes().length);
            OutputStream os = h.getResponseBody();
            os.write(response.getBytes());
            os.close();
        };
        try (TestServer server = new TestServer("/a/b", handler);){
            ExampleBean bean = (ExampleBean)TestHttpClient.get(server.getAddress()).path("a/b").get().readEntity(ExampleBean.class);
            Assertions.assertEquals((Object)inputBean, (Object)bean);
            bean = (ExampleBean)TestHttpClient.get(server.getAddress()).path("a/{b}").resolveTemplate("b", "b").get().readEntity(ExampleBean.class);
            Assertions.assertEquals((Object)inputBean, (Object)bean);
        }
    }

    @Test
    void testGetTemplateThrows() throws Exception {
        HttpHandler handler = h -> Assertions.fail();
        try (TestServer server = new TestServer("/a/b", handler);){
            Assertions.assertThrows(HttpClientException.class, () -> TestHttpClient.get(server.getAddress()).path("a/{b}").get().readEntity(ExampleBean.class));
            Assertions.assertThrows(HttpClientException.class, () -> TestHttpClient.get(server.getAddress()).path("a/b").resolveTemplate("b", "b").get().readEntity(ExampleBean.class));
        }
    }

    @Test
    void testFilters() throws Exception {
        AtomicBoolean requestFilterCalled = new AtomicBoolean(false);
        AtomicBoolean responseFilterCalled = new AtomicBoolean(false);
        AtomicReference responseContextGotCallback = new AtomicReference();
        AtomicReference responseContextGotFilter = new AtomicReference();
        HttpHandler handler = h -> {
            Assertions.assertTrue((boolean)h.getRequestHeaders().containsKey("x"));
            h.sendResponseHeaders(200, 0L);
        };
        try (TestServer server = new TestServer(handler);){
            HttpClient client = HttpClient.builder().setBaseUri(URI.create("http://localhost:" + server.getAddress().getPort())).setObjectMapper(MAPPER).build();
            client.register(context -> {
                requestFilterCalled.set(true);
                HashSet<String> headers = new HashSet<String>();
                headers.add("y");
                context.getHeaders().put("x", headers);
                context.addResponseCallback((responseContext, failure) -> {
                    responseContextGotCallback.set(responseContext);
                    Assertions.assertNull((Object)failure);
                });
            });
            client.register(con -> {
                try {
                    Assertions.assertEquals((Object)Status.OK, (Object)con.getResponseCode());
                    responseFilterCalled.set(true);
                    responseContextGotFilter.set(con);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            });
            client.newRequest().get();
            Assertions.assertNotNull(responseContextGotFilter.get());
            Assertions.assertSame(responseContextGotFilter.get(), responseContextGotCallback.get());
            Assertions.assertTrue((boolean)responseFilterCalled.get());
            Assertions.assertTrue((boolean)requestFilterCalled.get());
        }
    }

    @Test
    void testHeaders() throws Exception {
        HttpHandler handler = h -> {
            Assertions.assertTrue((boolean)h.getRequestHeaders().containsKey("x"));
            h.sendResponseHeaders(200, 0L);
        };
        try (TestServer server = new TestServer(handler);){
            TestHttpClient.get(server.getAddress()).header("x", "y").get();
        }
    }

    @Test
    void testMultiValueHeaders() throws Exception {
        HttpHandler handler = h -> {
            Assertions.assertTrue((boolean)h.getRequestHeaders().containsKey("x"));
            Object values = h.getRequestHeaders().get("x");
            Assertions.assertEquals((int)2, (int)values.size());
            Assertions.assertEquals((Object)"y", values.get(0));
            Assertions.assertEquals((Object)"z", values.get(1));
            h.sendResponseHeaders(200, 0L);
        };
        try (TestServer server = new TestServer(handler);){
            TestHttpClient.get(server.getAddress()).header("x", "y").header("x", "z").get();
        }
    }

    public static class ExampleBean {
        private String field1;
        private int field2;
        private Instant field3;

        public ExampleBean() {
        }

        public ExampleBean(String field1, int field2, Instant field3) {
            this.field1 = field1;
            this.field2 = field2;
            this.field3 = field3;
        }

        public String getField1() {
            return this.field1;
        }

        public int getField2() {
            return this.field2;
        }

        public ExampleBean setField1(String field1) {
            this.field1 = field1;
            return this;
        }

        public ExampleBean setField2(int field2) {
            this.field2 = field2;
            return this;
        }

        @JsonSerialize(using=CommitMeta.InstantSerializer.class)
        @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
        public Instant getField3() {
            return this.field3;
        }

        public void setField3(Instant field3) {
            this.field3 = field3;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExampleBean that = (ExampleBean)o;
            return this.field2 == that.field2 && Objects.equals(this.field1, that.field1) && Objects.equals(this.field3, that.field3);
        }

        public int hashCode() {
            return Objects.hash(this.field1, this.field2, this.field3);
        }
    }
}

