/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client;

import com.dremio.nessie.api.ContentsApi;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.model.ContentsKey;
import com.dremio.nessie.model.MultiGetContentsRequest;
import com.dremio.nessie.model.MultiGetContentsResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;

class ClientContentsApi
implements ContentsApi {
    private final WebTarget target;

    public ClientContentsApi(WebTarget target) {
        this.target = target;
    }

    public Contents getContents(@NotNull ContentsKey key, String ref) throws NessieNotFoundException {
        return (Contents)this.target.path("contents").path(key.toPathString()).queryParam("ref", new Object[]{ref}).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get().readEntity(Contents.class);
    }

    public MultiGetContentsResponse getMultipleContents(@NotNull String ref, @NotNull MultiGetContentsRequest request) throws NessieNotFoundException {
        return (MultiGetContentsResponse)this.target.path("contents").queryParam("ref", new Object[]{ref}).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)request, (MediaType)MediaType.APPLICATION_JSON_TYPE)).readEntity(MultiGetContentsResponse.class);
    }

    public void setContents(@NotNull ContentsKey key, String branch, @NotNull String hash, String message, @NotNull Contents contents) throws NessieNotFoundException, NessieConflictException {
        this.target.path("contents").path(key.toPathString()).queryParam("branch", new Object[]{branch}).queryParam("hash", new Object[]{hash}).queryParam("message", new Object[]{message}).request().post(Entity.entity((Object)contents, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void deleteContents(ContentsKey key, String branch, String hash, String message) throws NessieNotFoundException, NessieConflictException {
        this.target.path("contents").path(key.toPathString()).queryParam("branch", new Object[]{branch}).queryParam("hash", new Object[]{hash}).queryParam("message", new Object[]{message}).request().delete();
    }
}

