/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import com.sun.net.httpserver.HttpHandler;
import io.opentracing.Scope;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.auth.BasicAuthenticationProvider;
import org.projectnessie.client.auth.NessieAuthentication;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.client.rest.NessieInternalServerException;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.client.util.JaegerTestTracer;
import org.projectnessie.client.util.TestServer;

class TestNessieHttpClient {
    TestNessieHttpClient() {
    }

    @BeforeAll
    static void setupTracer() {
        JaegerTestTracer.register();
    }

    @Test
    void testNullUri() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> HttpClientBuilder.builder().withUri((URI)null).build(NessieApiV1.class)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot construct Http client. Must have a non-null uri");
    }

    @Test
    void testAuthBasic() throws Exception {
        AtomicReference<String> authHeader = new AtomicReference<String>();
        try (TestServer server = new TestServer(TestNessieHttpClient.handlerForHeaderTest("Authorization", authHeader));){
            NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri()).withAuthentication((NessieAuthentication)BasicAuthenticationProvider.create((String)"my_username", (String)"very_secret")).build(NessieApiV1.class);
            api.getConfig();
        }
        ((AbstractStringAssert)Assertions.assertThat((String)authHeader.get()).isNotNull()).isEqualTo("Basic " + new String(Base64.getUrlEncoder().encode("my_username:very_secret".getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
    }

    @Test
    void testTracing() throws Exception {
        AtomicReference<String> traceId = new AtomicReference<String>();
        try (TestServer server = new TestServer(TestNessieHttpClient.handlerForHeaderTest("Uber-trace-id", traceId));){
            NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri()).withTracing(true).build(NessieApiV1.class);
            try (Scope ignore = GlobalTracer.get().activateSpan(GlobalTracer.get().buildSpan("testOpenTracing").start());){
                api.getConfig();
            }
        }
        org.junit.jupiter.api.Assertions.assertNotNull((Object)traceId.get());
    }

    @Test
    void testTracingNotEnabled() throws Exception {
        AtomicReference<String> traceId = new AtomicReference<String>();
        try (TestServer server = new TestServer(TestNessieHttpClient.handlerForHeaderTest("Uber-trace-id", traceId));){
            NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri()).withTracing(false).build(NessieApiV1.class);
            try (Scope ignore = GlobalTracer.get().activateSpan(GlobalTracer.get().buildSpan("testOpenTracing").start());){
                api.getConfig();
            }
        }
        org.junit.jupiter.api.Assertions.assertNull((Object)traceId.get());
    }

    private TestServer errorServer(int status) throws IOException {
        return new TestServer(h -> {
            h.sendResponseHeaders(status, 0L);
            h.getResponseBody().close();
        });
    }

    @Test
    void testNotFoundOnBaseUri() throws IOException {
        try (TestServer server = this.errorServer(404);){
            NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri().resolve("/unknownPath")).build(NessieApiV1.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((NessieApiV1)api).getConfig()).isInstanceOf(RuntimeException.class)).hasMessageContaining("Not Found");
        }
    }

    @Test
    void testInternalServerError() throws IOException {
        try (TestServer server = this.errorServer(500);){
            NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri().resolve("/broken")).build(NessieApiV1.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((NessieApiV1)api).getConfig()).isInstanceOf(NessieInternalServerException.class)).hasMessageContaining("Internal Server Error");
        }
    }

    @Test
    void testUnauthorized() throws IOException {
        try (TestServer server = this.errorServer(401);){
            NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri().resolve("/unauthorized")).build(NessieApiV1.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((NessieApiV1)api).getConfig()).isInstanceOf(NessieNotAuthorizedException.class)).hasMessageContaining("Unauthorized");
        }
    }

    static HttpHandler handlerForHeaderTest(String headerName, AtomicReference<String> receiver) {
        return h -> {
            receiver.set(h.getRequestHeaders().getFirst(headerName));
            h.getRequestBody().close();
            byte[] body = "{\"maxSupportedApiVersion\":1}".getBytes(StandardCharsets.UTF_8);
            h.sendResponseHeaders(200, body.length);
            try (OutputStream out = h.getResponseBody();){
                out.write(body);
            }
        };
    }
}

