/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;
import org.projectnessie.client.auth.BasicAuthenticationProvider;
import org.projectnessie.client.auth.NessieAuthentication;
import org.projectnessie.client.auth.NessieAuthenticationProvider;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpHeaders;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.RequestFilter;

class TestBasicAuthProvider {
    TestBasicAuthProvider() {
    }

    @Test
    void testNullParams() {
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThatThrownBy(() -> new BasicAuthenticationProvider().build(arg_0 -> ((ImmutableMap)ImmutableMap.of((Object)"nessie.authentication.password", (Object)"pass")).get(arg_0))).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> new BasicAuthenticationProvider().build(arg_0 -> ((ImmutableMap)ImmutableMap.of((Object)"nessie.authentication.username", (Object)"user")).get(arg_0))).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> new BasicAuthenticationProvider().build(s -> null)).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> BasicAuthenticationProvider.create(null, (String)"pass")).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> BasicAuthenticationProvider.create((String)"user", null)).isInstanceOf(NullPointerException.class), () -> Assertions.assertThatThrownBy(() -> BasicAuthenticationProvider.create(null, null)).isInstanceOf(NullPointerException.class)});
    }

    @Test
    void testFromConfig() {
        ImmutableMap authCfg = ImmutableMap.of((Object)"nessie.authentication.type", (Object)"BASIC", (Object)"nessie.authentication.username", (Object)"Aladdin", (Object)"nessie.authentication.password", (Object)"OpenSesame");
        NessieAuthentication authentication = NessieAuthenticationProvider.fromConfig(((Map)authCfg)::get);
        this.checkAuth(authentication);
    }

    @Test
    void testFromConfigLegacy() {
        ImmutableMap authCfg = ImmutableMap.of((Object)"nessie.auth-type", (Object)"BASIC", (Object)"nessie.username", (Object)"Aladdin", (Object)"nessie.password", (Object)"OpenSesame");
        NessieAuthentication authentication = NessieAuthenticationProvider.fromConfig(((Map)authCfg)::get);
        this.checkAuth(authentication);
    }

    @Test
    void testStaticBuilder() {
        this.checkAuth((NessieAuthentication)BasicAuthenticationProvider.create((String)"Aladdin", (String)"OpenSesame"));
    }

    void checkAuth(NessieAuthentication authentication) {
        Assertions.assertThat((Object)authentication).isInstanceOf(HttpAuthentication.class);
        HttpAuthentication httpAuthentication = (HttpAuthentication)authentication;
        RequestFilter[] authFilter = new RequestFilter[1];
        HttpClient.Builder client = (HttpClient.Builder)Mockito.mock(HttpClient.Builder.class);
        ((HttpClient.Builder)Mockito.doAnswer(invocationOnMock -> {
            Object[] args = invocationOnMock.getArguments();
            if (args.length == 1 && args[0] instanceof RequestFilter) {
                authFilter[0] = (RequestFilter)args[0];
            }
            return null;
        }).when((Object)client)).addRequestFilter((RequestFilter)Mockito.any());
        httpAuthentication.applyToHttpClient(client);
        Assertions.assertThat((Object)authFilter[0]).isInstanceOf(RequestFilter.class);
        HttpHeaders headers = new HttpHeaders();
        RequestContext context = new RequestContext(headers, null, null, null);
        authFilter[0].filter(context);
        ((IterableAssert)((MapAssert)Assertions.assertThat((Map)headers.asMap()).containsKey((Object)"Authorization")).extracting("Authorization", InstanceOfAssertFactories.iterable(String.class))).containsExactly((Object[])new String[]{"Basic QWxhZGRpbjpPcGVuU2VzYW1l"});
    }
}

