/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;
import org.projectnessie.client.rest.NessieInternalServerException;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.client.rest.NessieServiceException;
import org.projectnessie.client.rest.ResponseCheckFilter;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ImmutableNessieError;
import org.projectnessie.error.NessieBackendThrottledException;
import org.projectnessie.error.NessieBadRequestException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieContentNotFoundException;
import org.projectnessie.error.NessieError;
import org.projectnessie.error.NessieForbiddenException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import software.amazon.awssdk.utils.StringInputStream;

public class TestResponseFilter {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @ParameterizedTest
    @MethodSource(value={"provider"})
    void testResponseFilter(Status responseCode, ErrorCode errorCode, Class<? extends Exception> clazz) {
        block3: {
            ImmutableNessieError error = ImmutableNessieError.builder().message("test-error").status(responseCode.getCode()).errorCode(errorCode).reason(responseCode.getReason()).serverStackTrace("xxx").build();
            try {
                ResponseCheckFilter.checkResponse((ResponseContext)new TestResponseContext(responseCode, (NessieError)error), (ObjectMapper)MAPPER);
            }
            catch (Exception e) {
                Assertions.assertThat((Throwable)e).isInstanceOf(clazz);
                if (e instanceof NessieServiceException) {
                    Assertions.assertThat((Object)((NessieServiceException)e).getError()).isEqualTo((Object)error);
                }
                if (!(e instanceof BaseNessieClientServerException)) break block3;
                Assertions.assertThat((int)((BaseNessieClientServerException)e).getStatus()).isEqualTo(error.getStatus());
                Assertions.assertThat((String)((BaseNessieClientServerException)e).getServerStackTrace()).isEqualTo(error.getServerStackTrace());
            }
        }
    }

    @Test
    void testBadReturn() {
        ImmutableNessieError error = ImmutableNessieError.builder().message("unknown").status(415).reason("xxx").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestResponseFilter.lambda$testBadReturn$0((NessieError)error)).isInstanceOf(RuntimeException.class)).hasMessage("xxx (HTTP/415): unknown");
    }

    @Test
    void testBadReturnNoError() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ResponseCheckFilter.checkResponse((ResponseContext)new ResponseContext(){

            public Status getResponseCode() {
                return Status.UNAUTHORIZED;
            }

            public InputStream getInputStream() {
                org.junit.jupiter.api.Assertions.fail();
                return null;
            }

            public InputStream getErrorStream() {
                return new StringInputStream("this will fail");
            }
        }, (ObjectMapper)MAPPER)).isInstanceOf(NessieNotAuthorizedException.class)).hasMessageContaining("" + Status.UNAUTHORIZED.getCode()).hasMessageContaining(Status.UNAUTHORIZED.getReason()).hasMessageContaining("JsonParseException");
    }

    @Test
    void testUnexpectedError() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ResponseCheckFilter.checkResponse((ResponseContext)new ResponseContext(){

            public Status getResponseCode() {
                return Status.NOT_IMPLEMENTED;
            }

            public InputStream getInputStream() {
                org.junit.jupiter.api.Assertions.fail();
                return null;
            }

            public InputStream getErrorStream() {
                return new StringInputStream("{\"details\":\"Error id ee7f7293-67ad-42bd-8973-179801e7120e-1\",\"stack\":\"\"}");
            }
        }, (ObjectMapper)MAPPER)).isInstanceOf(RuntimeException.class)).hasMessageContaining("" + Status.NOT_IMPLEMENTED.getCode()).hasMessageContaining(Status.NOT_IMPLEMENTED.getReason()).hasMessageContaining("ee7f7293-67ad-42bd-8973-179801e7120e-1").hasMessageContaining("UnrecognizedPropertyException");
    }

    @Test
    void testBadReturnBadError() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ResponseCheckFilter.checkResponse((ResponseContext)new TestResponseContext(Status.UNAUTHORIZED, null), (ObjectMapper)MAPPER)).isInstanceOf(NessieNotAuthorizedException.class)).hasMessageContaining("" + Status.UNAUTHORIZED.getCode()).hasMessageContaining(Status.UNAUTHORIZED.getReason()).hasMessageContaining("Could not parse error object in response");
    }

    @Test
    void testGood() {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ResponseCheckFilter.checkResponse((ResponseContext)new TestResponseContext(Status.OK, null), (ObjectMapper)MAPPER));
    }

    private static Stream<Arguments> provider() {
        return Stream.of(Arguments.of((Object[])new Object[]{Status.BAD_REQUEST, ErrorCode.UNKNOWN, RuntimeException.class}), Arguments.of((Object[])new Object[]{Status.BAD_REQUEST, ErrorCode.BAD_REQUEST, NessieBadRequestException.class}), Arguments.of((Object[])new Object[]{Status.UNAUTHORIZED, ErrorCode.UNKNOWN, NessieNotAuthorizedException.class}), Arguments.of((Object[])new Object[]{Status.FORBIDDEN, ErrorCode.FORBIDDEN, NessieForbiddenException.class}), Arguments.of((Object[])new Object[]{Status.FORBIDDEN, ErrorCode.UNKNOWN, NessieServiceException.class}), Arguments.of((Object[])new Object[]{Status.TOO_MANY_REQUESTS, ErrorCode.UNKNOWN, NessieServiceException.class}), Arguments.of((Object[])new Object[]{Status.TOO_MANY_REQUESTS, ErrorCode.TOO_MANY_REQUESTS, NessieBackendThrottledException.class}), Arguments.of((Object[])new Object[]{Status.NOT_FOUND, ErrorCode.CONTENT_NOT_FOUND, NessieContentNotFoundException.class}), Arguments.of((Object[])new Object[]{Status.NOT_FOUND, ErrorCode.REFERENCE_NOT_FOUND, NessieReferenceNotFoundException.class}), Arguments.of((Object[])new Object[]{Status.NOT_FOUND, ErrorCode.UNKNOWN, RuntimeException.class}), Arguments.of((Object[])new Object[]{Status.CONFLICT, ErrorCode.REFERENCE_CONFLICT, NessieConflictException.class}), Arguments.of((Object[])new Object[]{Status.CONFLICT, ErrorCode.UNKNOWN, RuntimeException.class}), Arguments.of((Object[])new Object[]{Status.INTERNAL_SERVER_ERROR, ErrorCode.UNKNOWN, NessieInternalServerException.class}));
    }

    private static /* synthetic */ void lambda$testBadReturn$0(NessieError error) throws Throwable {
        ResponseCheckFilter.checkResponse((ResponseContext)new TestResponseContext(Status.UNSUPPORTED_MEDIA_TYPE, error), (ObjectMapper)MAPPER);
    }

    private static class TestResponseContext
    implements ResponseContext {
        private final Status code;
        private final NessieError error;

        TestResponseContext(Status code, NessieError error) {
            this.code = code;
            this.error = error;
        }

        public Status getResponseCode() {
            return this.code;
        }

        public InputStream getInputStream() {
            org.junit.jupiter.api.Assertions.fail();
            return null;
        }

        public InputStream getErrorStream() throws IOException {
            if (this.error == null) {
                return null;
            }
            String value = MAPPER.writeValueAsString((Object)this.error);
            return new StringInputStream(value);
        }
    }
}

