/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.HashMap;
import org.projectnessie.api.http.HttpConfigApi;
import org.projectnessie.api.http.HttpContentApi;
import org.projectnessie.api.http.HttpDiffApi;
import org.projectnessie.api.http.HttpRefLogApi;
import org.projectnessie.api.http.HttpTreeApi;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpConfigClient;
import org.projectnessie.client.http.HttpContentClient;
import org.projectnessie.client.http.HttpDiffClient;
import org.projectnessie.client.http.HttpRefLogClient;
import org.projectnessie.client.http.HttpTreeClient;
import org.projectnessie.client.http.NessieApiClient;
import org.projectnessie.client.rest.NessieHttpResponseFilter;
import org.projectnessie.error.BaseNessieClientServerException;

public class NessieHttpClient
extends NessieApiClient {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    private final HttpClient client;

    NessieHttpClient(HttpAuthentication authentication, boolean enableTracing, HttpClient.Builder clientBuilder) {
        this(NessieHttpClient.buildClient(authentication, enableTracing, clientBuilder));
    }

    private static HttpClient buildClient(HttpAuthentication authentication, boolean enableTracing, HttpClient.Builder clientBuilder) {
        clientBuilder.setObjectMapper(MAPPER);
        if (enableTracing) {
            NessieHttpClient.addTracing(clientBuilder);
        }
        if (authentication != null) {
            authentication.applyToHttpClient(clientBuilder);
        }
        clientBuilder.addResponseFilter(new NessieHttpResponseFilter(MAPPER));
        return clientBuilder.build();
    }

    private NessieHttpClient(HttpClient client) {
        super(NessieHttpClient.wrap(HttpConfigApi.class, new HttpConfigClient(client)), NessieHttpClient.wrap(HttpTreeApi.class, new HttpTreeClient(client)), NessieHttpClient.wrap(HttpContentApi.class, new HttpContentClient(client)), NessieHttpClient.wrap(HttpDiffApi.class, new HttpDiffClient(client)), NessieHttpClient.wrap(HttpRefLogApi.class, new HttpRefLogClient(client)));
        this.client = client;
    }

    private static void addTracing(HttpClient.Builder httpClient) {
        Tracer tracer = GlobalTracer.get();
        if (tracer != null) {
            httpClient.addRequestFilter(context -> {
                Span span = tracer.activeSpan();
                if (span != null) {
                    Span inner = tracer.buildSpan("Nessie-HTTP").start();
                    Scope scope = tracer.activateSpan(inner);
                    context.addResponseCallback((responseContext, exception) -> {
                        if (responseContext != null) {
                            try {
                                inner.setTag("http.status_code", (Number)responseContext.getResponseCode().getCode());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (exception != null) {
                            HashMap<String, String> log = new HashMap<String, String>();
                            log.put("event", Tags.ERROR.getKey());
                            log.put("error.object", exception.toString());
                            Tags.ERROR.set(inner.log(log), Boolean.valueOf(true));
                        }
                        scope.close();
                    });
                    inner.setTag("http.uri", context.getUri().toString()).setTag("http.method", context.getMethod().name());
                    HashMap<String, String> headerMap = new HashMap<String, String>();
                    TextMapAdapter httpHeadersCarrier = new TextMapAdapter(headerMap);
                    tracer.inject(inner.context(), Format.Builtin.HTTP_HEADERS, (Object)httpHeadersCarrier);
                    headerMap.forEach(context::putHeader);
                }
            });
        }
    }

    private static <T> T wrap(Class<T> iface, T delegate) {
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new ExceptionRewriter(delegate));
    }

    public URI getUri() {
        return this.client.getBaseUri();
    }

    @Override
    public void close() {
    }

    private static class ExceptionRewriter
    implements InvocationHandler {
        private final Object delegate;

        public ExceptionRewriter(Object delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.delegate, args);
            }
            catch (InvocationTargetException ex) {
                Throwable cause;
                Throwable targetException = ex.getTargetException();
                if (targetException instanceof HttpClientException && (cause = targetException.getCause()) instanceof BaseNessieClientServerException) {
                    throw cause;
                }
                if (targetException instanceof RuntimeException) {
                    throw targetException;
                }
                throw ex;
            }
        }
    }
}

