/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import com.sun.net.httpserver.HttpHandler;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.client.api.NessieApi;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.auth.BasicAuthenticationProvider;
import org.projectnessie.client.auth.NessieAuthentication;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.client.util.TestServer;

public class TestHttpClientBuilder {
    @Test
    void testIncompatibleApiInterface() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> HttpClientBuilder.builder().withUri(URI.create("http://localhost")).build(IncompatibleApiInterface.class)).isInstanceOf(IllegalArgumentException.class)).hasMessage("API version org.projectnessie.client.http.TestHttpClientBuilder$IncompatibleApiInterface is not supported.");
    }

    @Test
    void testIncompatibleAuthProvider() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> HttpClientBuilder.builder().withUri(URI.create("http://localhost")).withAuthentication(new NessieAuthentication(){}).build(IncompatibleApiInterface.class)).isInstanceOf(IllegalArgumentException.class)).hasMessage("HttpClientBuilder only accepts instances of HttpAuthentication");
    }

    @Test
    void testNullUri() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> HttpClientBuilder.builder().withUri((URI)null).build(NessieApiV1.class)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot construct Http client. Must have a non-null uri");
    }

    @Test
    void testNoUri() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> HttpClientBuilder.builder().build(NessieApiV1.class)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot construct Http client. Must have a non-null uri");
    }

    @Test
    void testInvalidUriScheme() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> HttpClientBuilder.builder().withUri(URI.create("file:///foo/bar/baz")).build(NessieApiV1.class)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot start http client. file:///foo/bar/baz must be a valid http or https address");
    }

    static List<Function<HttpClientBuilder, HttpClientBuilder>> basicAuthConfigs() {
        return Arrays.asList(cfg -> cfg.withAuthentication((NessieAuthentication)BasicAuthenticationProvider.create((String)"my_username", (String)"very_secret")), cfg -> cfg.withAuthenticationFromConfig(prop -> {
            switch (prop) {
                case "nessie.authentication.type": {
                    return "BASIC";
                }
                case "nessie.authentication.username": {
                    return "my_username";
                }
                case "nessie.authentication.password": {
                    return "very_secret";
                }
            }
            return null;
        }));
    }

    @ParameterizedTest
    @MethodSource(value={"basicAuthConfigs"})
    void testAuthBasic(Function<HttpClientBuilder, HttpClientBuilder> config) throws Exception {
        AtomicReference<String> authHeader = new AtomicReference<String>();
        try (TestServer server = new TestServer(TestHttpClientBuilder.handlerForHeaderTest("Authorization", authHeader));){
            NessieApiV1 client = (NessieApiV1)config.apply(HttpClientBuilder.builder().withUri(server.getUri())).build(NessieApiV1.class);
            client.getConfig();
        }
        ((AbstractStringAssert)Assertions.assertThat((String)authHeader.get()).isNotNull()).isEqualTo("Basic " + new String(Base64.getUrlEncoder().encode("my_username:very_secret".getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
    }

    static HttpHandler handlerForHeaderTest(String headerName, AtomicReference<String> receiver) {
        return h -> {
            receiver.set(h.getRequestHeaders().getFirst(headerName));
            h.getRequestBody().close();
            byte[] body = "{\"maxSupportedApiVersion\":1}".getBytes(StandardCharsets.UTF_8);
            h.sendResponseHeaders(200, body.length);
            try (OutputStream out = h.getResponseBody();){
                out.write(body);
            }
        };
    }

    static interface IncompatibleApiInterface
    extends NessieApi {
    }
}

